/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.topic.util;

import com.icthh.xm.commons.logging.util.MdcUtils;
import java.math.BigInteger;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageRetryDetailsUtils {
    private static final Logger log = LoggerFactory.getLogger(MessageRetryDetailsUtils.class);
    private static ConcurrentHashMap<Record, MessageRetryDetails> retryDetails = new ConcurrentHashMap();

    public static MessageRetryDetails getUpdatedOrGenerateRetryDetails(ConsumerRecord<String, String> message) {
        Record record = new Record(message);
        MessageRetryDetails messageRetryDetails = retryDetails.get(record);
        log.debug("find retry details: {} for kafka message: {}", (Object)messageRetryDetails, message);
        if (messageRetryDetails == null) {
            messageRetryDetails = new MessageRetryDetails();
            messageRetryDetails.setRid(MdcUtils.generateRid());
            messageRetryDetails.setRetryCount(BigInteger.ONE);
            messageRetryDetails.setStartProcessTime(new Date().getTime());
            retryDetails.put(record, messageRetryDetails);
            log.debug("created retry details: {}, {}", (Object)record, (Object)messageRetryDetails);
        } else {
            messageRetryDetails.setRetryCount(messageRetryDetails.getRetryCount().add(BigInteger.ONE));
        }
        return messageRetryDetails;
    }

    public static BigInteger getRetryCounter(ConsumerRecord<?, ?> message) {
        Record record = new Record(message);
        return retryDetails.get(record) == null ? null : retryDetails.get(record).getRetryCount();
    }

    public static Long getTotalProcessingTime(ConsumerRecord<?, ?> message) {
        MessageRetryDetails messageRetryDetails = retryDetails.get(new Record(message));
        return messageRetryDetails == null ? null : Long.valueOf(new Date().getTime() - messageRetryDetails.getStartProcessTime());
    }

    public static String getRid(ConsumerRecord<?, ?> message) {
        Record record = new Record(message);
        return retryDetails.get(record) == null ? null : retryDetails.get(record).getRid();
    }

    public static void delete(ConsumerRecord<?, ?> message) {
        MessageRetryDetails result = retryDetails.remove(new Record(message));
        log.debug("deleted retry details: {}, for message: {}", (Object)result, message);
    }

    private MessageRetryDetailsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class Record {
        private String topic;
        private int partition;
        private long offset;
        private long timestamp;

        Record(ConsumerRecord<?, ?> message) {
            this.topic = message.topic();
            this.partition = message.partition();
            this.offset = message.offset();
            this.timestamp = message.timestamp();
        }

        public String getTopic() {
            return this.topic;
        }

        public int getPartition() {
            return this.partition;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public void setPartition(int partition) {
            this.partition = partition;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            Record other = (Record)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
                return false;
            }
            if (this.getPartition() != other.getPartition()) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            return this.getTimestamp() == other.getTimestamp();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Record;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            result = result * 59 + this.getPartition();
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            return result;
        }

        public String toString() {
            return "MessageRetryDetailsUtils.Record(topic=" + this.getTopic() + ", partition=" + this.getPartition() + ", offset=" + this.getOffset() + ", timestamp=" + this.getTimestamp() + ")";
        }
    }

    public static class MessageRetryDetails {
        private String rid;
        private BigInteger retryCount;
        private long startProcessTime;

        public String getRid() {
            return this.rid;
        }

        public BigInteger getRetryCount() {
            return this.retryCount;
        }

        public long getStartProcessTime() {
            return this.startProcessTime;
        }

        public void setRid(String rid) {
            this.rid = rid;
        }

        public void setRetryCount(BigInteger retryCount) {
            this.retryCount = retryCount;
        }

        public void setStartProcessTime(long startProcessTime) {
            this.startProcessTime = startProcessTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageRetryDetails)) {
                return false;
            }
            MessageRetryDetails other = (MessageRetryDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$rid = this.getRid();
            String other$rid = other.getRid();
            if (this$rid == null ? other$rid != null : !this$rid.equals(other$rid)) {
                return false;
            }
            BigInteger this$retryCount = this.getRetryCount();
            BigInteger other$retryCount = other.getRetryCount();
            if (this$retryCount == null ? other$retryCount != null : !((Object)this$retryCount).equals(other$retryCount)) {
                return false;
            }
            return this.getStartProcessTime() == other.getStartProcessTime();
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageRetryDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $rid = this.getRid();
            result = result * 59 + ($rid == null ? 43 : $rid.hashCode());
            BigInteger $retryCount = this.getRetryCount();
            result = result * 59 + ($retryCount == null ? 43 : ((Object)$retryCount).hashCode());
            long $startProcessTime = this.getStartProcessTime();
            result = result * 59 + (int)($startProcessTime >>> 32 ^ $startProcessTime);
            return result;
        }

        public String toString() {
            return "MessageRetryDetailsUtils.MessageRetryDetails(rid=" + this.getRid() + ", retryCount=" + this.getRetryCount() + ", startProcessTime=" + this.getStartProcessTime() + ")";
        }
    }
}

