/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.security.jwt;

import com.icthh.xm.commons.security.internal.XmAuthentication;
import com.icthh.xm.commons.security.internal.XmAuthenticationDetails;
import com.icthh.xm.commons.security.oauth2.JwtVerificationKeyClient;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.DefaultClock;
import io.jsonwebtoken.security.SignatureException;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Key;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class TokenProvider {
    private final Logger log = LoggerFactory.getLogger(TokenProvider.class);
    private static final String AUTHORITIES_KEY = "authorities";
    private static final String INVALID_JWT_TOKEN = "Invalid JWT token.";
    private final JwtParser jwtParser;

    @Autowired
    public TokenProvider(JwtVerificationKeyClient jwtVerificationKeyClient) {
        this(jwtVerificationKeyClient, DefaultClock.INSTANCE);
    }

    public TokenProvider(JwtVerificationKeyClient jwtVerificationKeyClient, Clock clock) {
        PublicKey key = jwtVerificationKeyClient.getVerificationKey();
        this.jwtParser = Jwts.parserBuilder().setSigningKey((Key)key).setClock(clock).build();
    }

    public XmAuthentication getAuthentication(HttpServletRequest request, String token) {
        Claims claims = (Claims)this.jwtParser.parseClaimsJws(token).getBody();
        Collection<? extends GrantedAuthority> authorities = this.getAuthorities(claims);
        XmAuthenticationDetails principal = new XmAuthenticationDetails(claims, request, token);
        return new XmAuthentication(principal, token, authorities);
    }

    public XmAuthentication getAuthentication(ServerHttpRequest request, String token) {
        Claims claims = (Claims)this.jwtParser.parseClaimsJws(token).getBody();
        Collection<? extends GrantedAuthority> authorities = this.getAuthorities(claims);
        XmAuthenticationDetails principal = new XmAuthenticationDetails(claims, request, token);
        return new XmAuthentication(principal, token, authorities);
    }

    private Collection<? extends GrantedAuthority> getAuthorities(Claims claims) {
        List authoritiesList = (List)claims.get(AUTHORITIES_KEY, List.class);
        return authoritiesList.stream().filter(auth -> !auth.trim().isEmpty()).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    public boolean validateToken(String authToken) {
        try {
            this.jwtParser.parseClaimsJws(authToken);
            return true;
        }
        catch (ExpiredJwtException | MalformedJwtException | UnsupportedJwtException | SignatureException e) {
            this.log.info(INVALID_JWT_TOKEN, e);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Token validation error {}", (Object)e.getMessage());
        }
        return false;
    }
}

