/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.security.internal;

import com.icthh.xm.commons.security.XmAuthenticationContext;
import com.icthh.xm.commons.security.internal.XmAuthenticationDetails;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

class SpringSecurityXmAuthenticationContext
implements XmAuthenticationContext {
    private static final Class<?> ANONYMOUS_AUTH_CLASS = AnonymousAuthenticationToken.class;
    private static final Class<?> REMEMBER_ME_AUTH_CLASS = RememberMeAuthenticationToken.class;
    private final SecurityContext securityContext;

    SpringSecurityXmAuthenticationContext(SecurityContext securityContext) {
        this.securityContext = Objects.requireNonNull(securityContext, "securityContext can't be null");
    }

    public Optional<Authentication> getAuthentication() {
        return Optional.ofNullable(this.securityContext.getAuthentication());
    }

    private Optional<Object> getDetails() {
        return this.getAuthentication().map(Authentication::getDetails);
    }

    @Override
    public boolean hasAuthentication() {
        return this.getAuthentication().isPresent();
    }

    @Override
    public boolean isAnonymous() {
        return this.getAuthentication().filter(auth -> ANONYMOUS_AUTH_CLASS.isAssignableFrom(auth.getClass())).isPresent();
    }

    @Override
    public boolean isAuthenticated() {
        return !this.isAnonymous();
    }

    @Override
    public boolean isFullyAuthenticated() {
        return this.getAuthentication().filter(auth -> !ANONYMOUS_AUTH_CLASS.isAssignableFrom(auth.getClass()) && !REMEMBER_ME_AUTH_CLASS.isAssignableFrom(auth.getClass())).isPresent();
    }

    @Override
    public Optional<String> getLogin() {
        return this.getAuthentication().map(auth -> {
            Object principal = auth.getPrincipal();
            if (principal instanceof UserDetails) {
                UserDetails userDetails = (UserDetails)principal;
                return userDetails.getUsername();
            }
            if (principal instanceof String) {
                return (String)principal;
            }
            return null;
        });
    }

    @Override
    public Optional<String> getClientId() {
        return this.xmAuthenticationDetails().map(XmAuthenticationDetails::getClientId);
    }

    @Override
    public String getRequiredClientId() {
        return this.getClientId().orElseThrow(() -> new IllegalStateException("Can't get clientId from authentication"));
    }

    @Override
    public Set<String> getScope() {
        return this.xmAuthenticationDetails().map(XmAuthenticationDetails::getScope).orElse(Collections.emptySet());
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.getAuthentication().map(Authentication::getAuthorities).orElse(Collections.emptyList());
    }

    @Override
    public Set<String> getAuthoritiesSet() {
        return this.xmAuthenticationDetails().map(XmAuthenticationDetails::getAuthorities).orElse(Collections.emptySet());
    }

    private Optional<XmAuthenticationDetails> xmAuthenticationDetails() {
        return this.getAuthentication().map(Authentication::getDetails).filter(it -> it instanceof XmAuthenticationDetails).map(XmAuthenticationDetails.class::cast);
    }

    @Override
    public String getRequiredLogin() {
        return this.getLogin().orElseThrow(() -> new IllegalStateException("Can't get login without authentication object"));
    }

    @Override
    public Optional<String> getRemoteAddress() {
        return this.getDetails().flatMap(details -> {
            String address;
            if (details instanceof XmAuthenticationDetails) {
                XmAuthenticationDetails xmDetails = (XmAuthenticationDetails)details;
                address = xmDetails.getRemoteAddress();
            } else if (details instanceof WebAuthenticationDetails) {
                WebAuthenticationDetails webAuthenticationDetails = (WebAuthenticationDetails)details;
                address = webAuthenticationDetails.getRemoteAddress();
            } else {
                throw new IllegalStateException("Unsupported auth details type " + String.valueOf(details.getClass()));
            }
            return Optional.ofNullable(address);
        });
    }

    @Override
    public Optional<String> getSessionId() {
        return this.getDetails().flatMap(details -> {
            String sessionId;
            if (details instanceof XmAuthenticationDetails) {
                XmAuthenticationDetails xmDetails = (XmAuthenticationDetails)details;
                sessionId = xmDetails.getSessionId();
            } else if (details instanceof WebAuthenticationDetails) {
                WebAuthenticationDetails webAuthenticationDetails = (WebAuthenticationDetails)details;
                sessionId = webAuthenticationDetails.getSessionId();
            } else {
                throw new IllegalStateException("Unsupported auth details type " + String.valueOf(details.getClass()));
            }
            return Optional.ofNullable(sessionId);
        });
    }

    @Override
    public Optional<String> getUserKey() {
        return this.getDetailsValue("user_key");
    }

    @Override
    public String getRequiredUserKey() {
        return this.getUserKey().orElseThrow(() -> new IllegalStateException("Can't get userKey without authentication object"));
    }

    @Override
    public Optional<String> getTokenValue() {
        return this.getDetails().flatMap(details -> {
            if (!(details instanceof XmAuthenticationDetails)) {
                throw new IllegalStateException("Unsupported token auth details type " + String.valueOf(details.getClass()));
            }
            XmAuthenticationDetails xmDetails = (XmAuthenticationDetails)details;
            String tokenValue = xmDetails.getTokenValue();
            return Optional.ofNullable(tokenValue);
        });
    }

    @Override
    public Optional<String> getTokenType() {
        return this.getDetails().flatMap(details -> {
            if (!(details instanceof XmAuthenticationDetails)) {
                throw new IllegalStateException("Unsupported token type auth details type " + String.valueOf(details.getClass()));
            }
            XmAuthenticationDetails xmDetails = (XmAuthenticationDetails)details;
            String tokenType = xmDetails.getTokenType();
            return Optional.ofNullable(tokenType);
        });
    }

    @Override
    public Optional<String> getDetailsValue(String key) {
        return this.getDetailsValue(key, String.class);
    }

    @Override
    public String getDetailsValue(String key, String defaultValue) {
        return this.getDetailsValue(key).orElse(defaultValue);
    }

    @Override
    public Optional<String> getAdditionalDetailsValue(String key) {
        return this.getDetailsValue("additionalDetails", HashMap.class).map(additionalDetails -> (String)additionalDetails.get(key));
    }

    @Override
    public String getAdditionalDetailsValue(String key, String defaultValue) {
        return this.getAdditionalDetailsValue(key).orElse(defaultValue);
    }

    @Override
    public Map<String, Object> getDecodedDetails() {
        return this.getDetails().map(this::toDecodedDetails).orElseGet(HashMap::new);
    }

    @Override
    public Optional<String> getTenantName() {
        return this.getDetailsValue("tenant");
    }

    private Map<String, Object> toDecodedDetails(Object details) {
        if (details instanceof XmAuthenticationDetails) {
            XmAuthenticationDetails xmDetails = (XmAuthenticationDetails)details;
            return xmDetails.getDecodedDetails();
        }
        if (details instanceof WebAuthenticationDetails) {
            return null;
        }
        throw new IllegalStateException("Unsupported auth details type " + String.valueOf(details.getClass()));
    }

    @Deprecated(forRemoval=true)
    private Optional<Map<String, Object>> getDetailsMap() {
        return Optional.of(this.getDecodedDetails());
    }

    private <T> Optional<T> getDetailsValue(String key, Class<T> valueType) {
        return this.getDetailsMap().map(allDetail -> {
            Object value = allDetail.get(key);
            if (value == null) {
                return null;
            }
            if (!valueType.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException(String.format("Can't convert detail with type %s to %s", value.getClass().getName(), valueType.getName()));
            }
            return valueType.cast(value);
        });
    }
}

