/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.security.oauth2;

import com.icthh.xm.commons.security.oauth2.JwtVerificationKeyClient;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class FileVerificationKeyClient
implements JwtVerificationKeyClient {
    private static final Logger log = LoggerFactory.getLogger(FileVerificationKeyClient.class);
    private final String configDirPath;

    public FileVerificationKeyClient(@Value(value="${xm-config.configDirPath}") String configDirPath) {
        this.configDirPath = configDirPath;
    }

    @Override
    public byte[] fetchKeyContent() {
        try {
            Path keyPath = Path.of(this.configDirPath, "config", "public.cer");
            byte[] content = Files.readAllBytes(keyPath);
            if (ArrayUtils.isEmpty((byte[])content)) {
                log.warn("Public key not fetched from path: {}", (Object)keyPath);
                return null;
            }
            return content;
        }
        catch (IOException ex) {
            log.warn("Could not get public key, exception: {}", (Object)ex.getMessage());
            return null;
        }
    }
}

