/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.security.jwt;

import com.icthh.xm.commons.security.internal.XmAuthentication;
import com.icthh.xm.commons.security.jwt.TokenProvider;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class JWTFilter
extends GenericFilterBean {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private final TokenProvider tokenProvider;

    public JWTFilter(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String jwt = this.resolveToken(httpServletRequest);
        if (StringUtils.hasText((String)jwt) && this.tokenProvider.validateToken(jwt)) {
            XmAuthentication authentication = this.tokenProvider.getAuthentication(httpServletRequest, jwt);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private String resolveToken(HttpServletRequest request) {
        String bearerToken = request.getHeader(AUTHORIZATION_HEADER);
        if (StringUtils.hasText((String)bearerToken) && (bearerToken.startsWith("Bearer ") || bearerToken.toUpperCase().startsWith("BEARER "))) {
            String token = bearerToken.substring(7);
            if (StringUtils.hasText((String)token)) {
                token = token.strip();
            }
            return token;
        }
        return null;
    }
}

