/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.security.oauth2;

import com.icthh.xm.commons.security.oauth2.JwtVerificationKeyClient;
import com.icthh.xm.commons.security.oauth2.OAuth2Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ConfigVerificationKeyClient
implements JwtVerificationKeyClient {
    private static final Logger log = LoggerFactory.getLogger(ConfigVerificationKeyClient.class);
    private final RestTemplate restTemplate;
    private final OAuth2Properties oauth2Properties;

    public ConfigVerificationKeyClient(OAuth2Properties oauth2Properties, @Qualifier(value="xm-config-rest-template") RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.oauth2Properties = oauth2Properties;
    }

    @Override
    public byte[] fetchKeyContent() {
        try {
            HttpEntity request = new HttpEntity((MultiValueMap)new HttpHeaders());
            byte[] content = (byte[])this.restTemplate.exchange(this.getPublicKeyEndpoint(), HttpMethod.GET, request, byte[].class, new Object[0]).getBody();
            if (ArrayUtils.isEmpty((byte[])content)) {
                log.warn("Public key not fetched from endpoint: {}", (Object)this.getPublicKeyEndpoint());
                return null;
            }
            return content;
        }
        catch (IllegalArgumentException ex) {
            log.error("Could not contact xm-ms-config to get public key, exception: {}", (Object)ex.getMessage());
            return null;
        }
    }

    private String getPublicKeyEndpoint() {
        String tokenEndpointUrl = this.oauth2Properties.getSignatureVerification().getPublicKeyEndpointUri();
        if (tokenEndpointUrl == null) {
            throw new IllegalStateException("no token endpoint configured in application properties");
        }
        return tokenEndpointUrl;
    }
}

