/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.spring.config;

import com.icthh.xm.commons.tenant.XmRelatedComponent;
import com.icthh.xm.commons.web.spring.TenantInterceptor;
import com.icthh.xm.commons.web.spring.XmLoggingInterceptor;
import com.icthh.xm.commons.web.spring.config.XmMsWebConfiguration;
import com.icthh.xm.commons.web.spring.config.XmWebMvcConfigurerAdapter;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;

@Configuration
@Import(value={XmMsWebConfiguration.class})
public class WebMvcConfig
extends XmWebMvcConfigurerAdapter {
    private final List<AsyncHandlerInterceptor> interceptors;
    private final List<String> tenantIgnoredPathList;

    public WebMvcConfig(@Value(value="${application.tenant-ignored-path-list}") List<String> tenantIgnoredPathList, TenantInterceptor tenantInterceptor, XmLoggingInterceptor xmLoggingInterceptor, List<AsyncHandlerInterceptor> interceptors) {
        super(tenantInterceptor, xmLoggingInterceptor);
        this.interceptors = interceptors.stream().filter(it -> it.getClass().isAnnotationPresent(XmRelatedComponent.class)).toList();
        this.tenantIgnoredPathList = tenantIgnoredPathList;
    }

    @Override
    protected void xmAddInterceptors(InterceptorRegistry registry) {
        this.interceptors.forEach(interceptor -> this.registerTenantInterceptorWithIgnorePathPattern(registry, (HandlerInterceptor)interceptor));
    }

    @Override
    protected void xmConfigurePathMatch(PathMatchConfigurer configurer) {
    }

    @Override
    protected List<String> getTenantIgnorePathPatterns() {
        return this.tenantIgnoredPathList;
    }
}

