/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.spring.config;

import com.icthh.xm.commons.web.spring.TenantInterceptor;
import com.icthh.xm.commons.web.spring.TenantVerifyInterceptor;
import com.icthh.xm.commons.web.spring.XmLoggingInterceptor;
import com.icthh.xm.commons.web.spring.config.XmMsWebConfiguration;
import com.icthh.xm.commons.web.spring.config.XmWebMvcConfigurerAdapter;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;

@Configuration
@Import(value={XmMsWebConfiguration.class})
public class WebMvcConfig
extends XmWebMvcConfigurerAdapter {
    private final TenantVerifyInterceptor tenantVerifyInterceptor;
    private final List<String> tenantIgnoredPathList;

    public WebMvcConfig(@Value(value="${application.tenant-ignored-path-list}") List<String> tenantIgnoredPathList, TenantInterceptor tenantInterceptor, XmLoggingInterceptor xmLoggingInterceptor, TenantVerifyInterceptor tenantVerifyInterceptor) {
        super(tenantInterceptor, xmLoggingInterceptor);
        this.tenantVerifyInterceptor = tenantVerifyInterceptor;
        this.tenantIgnoredPathList = tenantIgnoredPathList;
    }

    @Override
    protected void xmAddInterceptors(InterceptorRegistry registry) {
        this.registerTenantInterceptorWithIgnorePathPattern(registry, (HandlerInterceptor)this.tenantVerifyInterceptor);
    }

    @Override
    protected void xmConfigurePathMatch(PathMatchConfigurer configurer) {
    }

    @Override
    protected List<String> getTenantIgnorePathPatterns() {
        return this.tenantIgnoredPathList;
    }
}

