/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.spring.config;

import com.icthh.xm.commons.web.spring.TenantInterceptor;
import com.icthh.xm.commons.web.spring.XmLoggingInterceptor;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public abstract class XmWebMvcConfigurerAdapter
implements WebMvcConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmWebMvcConfigurerAdapter.class);
    private final TenantInterceptor tenantInterceptor;
    private final XmLoggingInterceptor xmLoggingInterceptor;

    protected XmWebMvcConfigurerAdapter(TenantInterceptor tenantInterceptor, XmLoggingInterceptor xmLoggingInterceptor) {
        this.tenantInterceptor = tenantInterceptor;
        this.xmLoggingInterceptor = xmLoggingInterceptor;
    }

    public final void addInterceptors(InterceptorRegistry registry) {
        this.registerTenantInterceptorWithIgnorePathPattern(registry, (HandlerInterceptor)this.tenantInterceptor);
        this.registerXmLoggingInterceptor(registry);
        this.xmAddInterceptors(registry);
    }

    protected abstract void xmAddInterceptors(InterceptorRegistry var1);

    public final void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseSuffixPatternMatch(Boolean.valueOf(false));
        this.xmConfigurePathMatch(configurer);
    }

    protected abstract void xmConfigurePathMatch(PathMatchConfigurer var1);

    protected void registerTenantInterceptorWithIgnorePathPattern(InterceptorRegistry registry, HandlerInterceptor interceptor) {
        InterceptorRegistration tenantInterceptorRegistration = registry.addInterceptor(interceptor);
        tenantInterceptorRegistration.addPathPatterns(new String[]{"/**"});
        List<String> tenantIgnorePathPatterns = this.getTenantIgnorePathPatterns();
        Objects.requireNonNull(tenantIgnorePathPatterns, "tenantIgnorePathPatterns can't be null");
        for (String pattern : tenantIgnorePathPatterns) {
            tenantInterceptorRegistration.excludePathPatterns(new String[]{pattern});
        }
        LOGGER.info("Added handler interceptor '{}' to all urls, exclude {}", (Object)interceptor.getClass().getSimpleName(), tenantIgnorePathPatterns);
    }

    protected abstract List<String> getTenantIgnorePathPatterns();

    private void registerXmLoggingInterceptor(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.xmLoggingInterceptor).addPathPatterns(new String[]{"/**"});
        LOGGER.info("Added handler interceptor '{}' to all urls", (Object)XmLoggingInterceptor.class.getSimpleName());
    }
}

