/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.spring;

import com.icthh.xm.commons.security.XmAuthenticationContext;
import com.icthh.xm.commons.security.XmAuthenticationContextHolder;
import com.icthh.xm.commons.tenant.PlainTenant;
import com.icthh.xm.commons.tenant.PrivilegedTenantContext;
import com.icthh.xm.commons.tenant.Tenant;
import com.icthh.xm.commons.tenant.TenantContext;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import com.icthh.xm.commons.tenant.TenantKey;
import com.icthh.xm.commons.web.spring.InterceptorUtil;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class TenantInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantInterceptor.class);
    private static final String JSON_ERROR_NO_TENANT_SUPPLIED = "{\"error\": \"No tenant supplied.\"}";
    private final TenantContextHolder tenantContextHolder;
    private final XmAuthenticationContextHolder xmAuthContextHolder;

    public TenantInterceptor(XmAuthenticationContextHolder xmAuthenticationContextHolder, TenantContextHolder tenantContextHolder) {
        this.tenantContextHolder = Objects.requireNonNull(tenantContextHolder, "tenantContextHolder can't be null");
        this.xmAuthContextHolder = Objects.requireNonNull(xmAuthenticationContextHolder, "xmAuthenticationContextHolder can't be null");
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        Optional<Object> tenantName;
        XmAuthenticationContext authContext = this.xmAuthContextHolder.getContext();
        boolean isFullyAuthenticated = authContext.isFullyAuthenticated();
        if (isFullyAuthenticated) {
            tenantName = authContext.getDetailsValue("tenant");
        } else {
            String tenantNameValue = request.getHeader("x-tenant");
            Optional<Object> optional = tenantName = StringUtils.isNotBlank((CharSequence)tenantNameValue) ? Optional.of(tenantNameValue) : Optional.empty();
        }
        if (tenantName.isPresent()) {
            PlainTenant tenant = new PlainTenant(TenantKey.valueOf((String)((String)tenantName.get())));
            LOGGER.debug("Init tenant '{}' context", (Object)tenant.getTenantKey().getValue());
            this.getPrivilegedTenantContext().setTenant((Tenant)tenant);
            return true;
        }
        if (isFullyAuthenticated) {
            LOGGER.warn("Can't obtain tenant name from authentication details");
        } else {
            LOGGER.warn("Can't obtain tenant name from non auth http request header '{}'", (Object)"x-tenant");
        }
        InterceptorUtil.sendResponse(response, JSON_ERROR_NO_TENANT_SUPPLIED);
        return false;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        PrivilegedTenantContext privilegedTenantContext = this.getPrivilegedTenantContext();
        LOGGER.debug("Destroy tenant '{}' context", (Object)TenantContextUtils.getRequiredTenantKeyValue((TenantContext)privilegedTenantContext));
        privilegedTenantContext.destroyCurrentContext();
    }

    private PrivilegedTenantContext getPrivilegedTenantContext() {
        return this.tenantContextHolder.getPrivilegedContext();
    }
}

