/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.tenant.provisioner;

import com.icthh.xm.commons.gen.model.Tenant;
import com.icthh.xm.commons.migration.db.liquibase.LiquibaseRunner;
import com.icthh.xm.commons.migration.db.tenant.DropSchemaResolver;
import com.icthh.xm.commons.migration.db.util.DatabaseUtil;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import com.icthh.xm.commons.tenantendpoint.provisioner.TenantProvisioner;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.stereotype.Service;

@Service
public class TenantDatabaseProvisioner
implements TenantProvisioner {
    private static final Logger log = LoggerFactory.getLogger(TenantDatabaseProvisioner.class);
    private final DataSource dataSource;
    private final LiquibaseProperties properties;
    private final DropSchemaResolver schemaDropResolver;
    private final LiquibaseRunner liquibaseRunner;
    private final String dbSchemaSuffix;

    public TenantDatabaseProvisioner(DataSource dataSource, LiquibaseProperties properties, DropSchemaResolver schemaDropResolver, LiquibaseRunner liquibaseRunner, @Value(value="${application.db-schema-suffix:}") String dbSchemaSuffix) {
        this.dataSource = dataSource;
        this.properties = properties;
        this.schemaDropResolver = schemaDropResolver;
        this.liquibaseRunner = liquibaseRunner;
        this.dbSchemaSuffix = dbSchemaSuffix;
    }

    public void createTenant(Tenant tenant) {
        String tenantKey = tenant.getTenantKey().toUpperCase();
        TenantContextUtils.assertTenantKeyValid((String)tenantKey);
        String schema = this.resolveSchemaName(tenantKey);
        this.createSchema(schema);
        this.migrateSchema(schema);
    }

    public void manageTenant(String tenantKey, String state) {
        log.info("Nothing to do with DB during manage tenant: {}, state = {}", (Object)tenantKey, (Object)state);
    }

    public void deleteTenant(String tenantKey) {
        TenantContextUtils.assertTenantKeyValid((String)tenantKey);
        String schema = this.resolveSchemaName(tenantKey);
        String sql = String.format(this.schemaDropResolver.getSchemaDropCommand(), schema);
        DatabaseUtil.executeUpdateWithAutoCommit(this.dataSource, sql);
    }

    private void createSchema(String schema) throws SQLException {
        String sql = String.format("CREATE SCHEMA IF NOT EXISTS %s", schema);
        DatabaseUtil.executeUpdateWithAutoCommit(this.dataSource, sql);
    }

    protected void migrateSchema(String schema) {
        String changeLogPath = this.getChangelogPath();
        this.liquibaseRunner.runOnTenant(schema, changeLogPath);
    }

    private String getChangelogPath() {
        return Optional.ofNullable(this.properties.getChangeLog()).filter(StringUtils::isNotEmpty).orElse("classpath:config/liquibase/master.xml");
    }

    private String resolveSchemaName(String tenantKey) {
        return StringUtils.isBlank((CharSequence)this.dbSchemaSuffix) ? tenantKey.toUpperCase() : (tenantKey + this.dbSchemaSuffix).toUpperCase();
    }
}

