/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.jsonb;

import com.icthh.xm.commons.migration.db.jsonb.CustomDialect;
import org.hibernate.dialect.PostgreSQL95Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.sql.BinaryTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class CustomPostgreSQL95Dialect
extends PostgreSQL95Dialect
implements CustomDialect {
    public static final String JSON_QUERY_TEMPLATE = "jsonb_path_query_first(?1, ?2::jsonpath)";
    public static final String JSON_EXTRACT_PATH = "jsonb_extract_path_text";
    public static final String JSON_EXTRACT_PATH_TEMPLATE = "jsonb_to_string";
    public static final String TO_JSON_B = "to_json_b";
    public static final String TO_JSON_B_TEMPLATE = "to_jsonb(?1)";

    public CustomPostgreSQL95Dialect() {
        this.registerColumnType(2004, "bytea");
        this.registerFunction("json_query", (SQLFunction)new SQLFunctionTemplate((Type)StringType.INSTANCE, JSON_QUERY_TEMPLATE));
        this.registerFunction(TO_JSON_B, (SQLFunction)new SQLFunctionTemplate((Type)StringType.INSTANCE, TO_JSON_B_TEMPLATE));
        this.registerFunction(JSON_EXTRACT_PATH_TEMPLATE, (SQLFunction)new StandardSQLFunction(JSON_EXTRACT_PATH, (Type)StringType.INSTANCE));
    }

    public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        if (sqlTypeDescriptor.getSqlType() == 2004) {
            return BinaryTypeDescriptor.INSTANCE;
        }
        return super.remapSqlTypeDescriptor(sqlTypeDescriptor);
    }
}

