/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.jsonb;

import com.icthh.xm.commons.migration.db.jsonb.CustomExpression;
import com.icthh.xm.commons.migration.db.jsonb.HibernateInlineExpression;
import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="'${spring.datasource.url}'.startsWith('jdbc:postgresql:')")
public class JsonbExpression
implements CustomExpression {
    @Override
    public Expression<JsonBinaryType> jsonQuery(CriteriaBuilder cb, Root<?> root, String column, String jsonPath) {
        return this.jsonQuery(cb, root, column, jsonPath, JsonBinaryType.class);
    }

    @Override
    public <T> Expression<T> jsonQuery(CriteriaBuilder cb, Root<?> root, String column, String jsonPath, Class<T> type) {
        return cb.function("json_query", type, new Expression[]{root.get(column), new HibernateInlineExpression(cb, jsonPath)});
    }

    @Override
    public Expression<?> toExpression(CriteriaBuilder cb, Object object) {
        return this.toJsonB(cb, object);
    }

    @Override
    public Expression<?> toJsonB(CriteriaBuilder cb, Object object) {
        return this.toJsonB(cb, object, JsonBinaryType.class);
    }

    @Override
    public <T> Expression<T> toJsonB(CriteriaBuilder cb, Object object, Class<T> type) {
        return this.toJsonB(cb, cb.literal(object), type);
    }

    @Override
    public Expression<JsonBinaryType> toJsonB(CriteriaBuilder cb, Expression<?> expression) {
        return this.toJsonB(cb, expression, JsonBinaryType.class);
    }

    @Override
    public <T> Expression<T> toJsonB(CriteriaBuilder cb, Expression<?> expression, Class<T> type) {
        return cb.function("to_json_b", type, new Expression[]{expression});
    }
}

