/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db.tenant.provisioner;

import com.icthh.xm.commons.gen.model.Tenant;
import com.icthh.xm.commons.migration.db.tenant.DropSchemaResolver;
import com.icthh.xm.commons.migration.db.util.DatabaseUtil;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import com.icthh.xm.commons.tenantendpoint.provisioner.TenantProvisioner;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;

@Service
public class TenantDatabaseProvisioner
implements TenantProvisioner {
    private static final Logger log = LoggerFactory.getLogger(TenantDatabaseProvisioner.class);
    private final DataSource dataSource;
    private final LiquibaseProperties properties;
    private final ResourceLoader resourceLoader;
    private final DropSchemaResolver schemaDropResolver;

    public void createTenant(Tenant tenant) {
        String tenantKey = tenant.getTenantKey().toUpperCase();
        TenantContextUtils.assertTenantKeyValid((String)tenantKey);
        this.createSchema(tenantKey);
        this.migrateSchema(tenantKey);
    }

    public void manageTenant(String tenantKey, String state) {
        log.info("Nothing to do with DB during manage tenant: {}, state = {}", (Object)tenantKey, (Object)state);
    }

    public void deleteTenant(String tenantKey) {
        String tenantKeyUpper = tenantKey.toUpperCase();
        TenantContextUtils.assertTenantKeyValid((String)tenantKeyUpper);
        String sql = String.format(this.schemaDropResolver.getSchemaDropCommand(), tenantKeyUpper);
        DatabaseUtil.executeUpdateWithAutoCommit(this.dataSource, sql);
    }

    private void createSchema(String tenantKey) throws SQLException {
        String sql = String.format("CREATE SCHEMA IF NOT EXISTS %s", tenantKey);
        DatabaseUtil.executeUpdateWithAutoCommit(this.dataSource, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void migrateSchema(String tenantKey) {
        String changeLogPath = this.getChangelogPath();
        StopWatch stopWatch = StopWatch.createStarted();
        log.info("start Liquibase migration for tenant {}, changelog path: {}", (Object)tenantKey, (Object)changeLogPath);
        try {
            SpringLiquibase liquibase = new SpringLiquibase();
            liquibase.setResourceLoader(this.resourceLoader);
            liquibase.setDataSource(this.dataSource);
            liquibase.setChangeLog(changeLogPath);
            liquibase.setContexts(this.properties.getContexts());
            liquibase.setDefaultSchema(tenantKey);
            liquibase.setDropFirst(this.properties.isDropFirst());
            liquibase.setChangeLogParameters(this.properties.getParameters());
            liquibase.setShouldRun(true);
            liquibase.afterPropertiesSet();
        }
        finally {
            log.info("stop  Liquibase migration for tenant {}, time: {} ms", (Object)tenantKey, (Object)stopWatch.getTime());
        }
    }

    private String getChangelogPath() {
        return Optional.ofNullable(this.properties.getChangeLog()).filter(StringUtils::isNotEmpty).orElse("classpath:config/liquibase/master.xml");
    }

    public TenantDatabaseProvisioner(DataSource dataSource, LiquibaseProperties properties, ResourceLoader resourceLoader, DropSchemaResolver schemaDropResolver) {
        this.dataSource = dataSource;
        this.properties = properties;
        this.resourceLoader = resourceLoader;
        this.schemaDropResolver = schemaDropResolver;
    }
}

