/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.migration.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class DatabaseTxIdResolver {
    private static final Logger log = LoggerFactory.getLogger(DatabaseTxIdResolver.class);
    private static final String POSTGRES_OLD_METHOD = "txid_current";
    private static final String POSTGRES_NEW_METHOD = "pg_current_xact_id";
    private static final ThreadLocal<Map<TransactionStatus, String>> transactionHolder = ThreadLocal.withInitial(WeakHashMap::new);
    private final String dbTransactionIdCommand;
    private final DataSource dataSource;

    public DatabaseTxIdResolver(Environment env, DataSource dataSource) {
        this.dataSource = dataSource;
        String jpaVendor = env.getProperty("spring.jpa.database");
        Objects.requireNonNull(jpaVendor, "Unknown JPA vendor");
        this.dbTransactionIdCommand = this.initDbCommand(jpaVendor);
    }

    private String initDbCommand(String jpaVendor) {
        switch (jpaVendor) {
            case "POSTGRESQL": {
                return String.format("SELECT CAST(%s() AS text);", this.getPostgresTxIdMethod(this.dataSource));
            }
            case "ORACLE": {
                return "SELECT RAWTOHEX(tx.xid) FROM v$transaction tx JOIN v$session s ON tx.addr=s.taddr";
            }
            case "H2": {
                return "SELECT 'not_implemented'";
            }
        }
        throw new IllegalStateException("Cant define sql command to get transaction id, database: " + jpaVendor + " not supported.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPostgresTxIdMethod(DataSource dataSource) {
        String methodExistsSql = "select exists(select * from pg_proc where proname = ?);";
        try (PreparedStatement stmt = dataSource.getConnection().prepareStatement(methodExistsSql);){
            stmt.setString(1, POSTGRES_NEW_METHOD);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                boolean methodExists = rs.getBoolean(1);
                String string2 = methodExists ? POSTGRES_NEW_METHOD : POSTGRES_OLD_METHOD;
                return string2;
            }
            String string = POSTGRES_OLD_METHOD;
            return string;
        }
        catch (SQLException sqlException) {
            throw new HibernateException("Error occurred while receiving postgreSQL method to get current transaction id: ", (Throwable)sqlException);
        }
    }

    public String getDatabaseTransactionId() {
        TransactionStatus transactionStatus = null;
        try {
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                transactionStatus = TransactionAspectSupport.currentTransactionStatus();
            } else {
                log.debug("No transaction is found for thread {}", (Object)Thread.currentThread().getName());
            }
        }
        catch (Exception e) {
            log.error("Not possible to get transaction id.", (Throwable)e);
        }
        if (transactionStatus == null || this.isReadOnly(transactionStatus)) {
            return null;
        }
        return transactionHolder.get().computeIfAbsent(transactionStatus, k -> this.getDbTransactionId());
    }

    private boolean isReadOnly(TransactionStatus transactionStatus) {
        return transactionStatus instanceof DefaultTransactionStatus && ((DefaultTransactionStatus)transactionStatus).isReadOnly();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDbTransactionId() {
        try (Statement stmt = this.dataSource.getConnection().createStatement();){
            ResultSet rs = stmt.executeQuery(this.dbTransactionIdCommand);
            if (rs.next()) {
                String string2 = rs.getString(1);
                return string2;
            }
            log.error("Transaction is not open for thread: {}", (Object)Thread.currentThread().getName());
            String string = null;
            return string;
        }
        catch (SQLException sqlException) {
            throw new HibernateException("Cant get db transaction id for thread: " + Thread.currentThread().getName(), (Throwable)sqlException);
        }
    }
}

