/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.messaging.communication;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.icthh.xm.commons.messaging.communication.CommunicationMessage;
import com.icthh.xm.commons.messaging.communication.CommunicationRequestCharacteristic;
import com.icthh.xm.commons.messaging.communication.Receiver;
import com.icthh.xm.commons.messaging.communication.Sender;
import java.util.Map;

public class CommunicationMessageBuilder {
    private final CommunicationMessage communicationMessage;
    private final ObjectMapper objectMapper;

    public CommunicationMessageBuilder addTemplateModel(Map<String, Object> templateModel) {
        String convertedModel = this.objectMapper.writeValueAsString(templateModel);
        return this.addCharacteristic("templateModel", convertedModel);
    }

    public CommunicationMessageBuilder addLanguage(String language) {
        return this.addCharacteristic("language", language);
    }

    public CommunicationMessageBuilder addTemplateName(String templateName) {
        return this.addCharacteristic("templateName", templateName);
    }

    public CommunicationMessageBuilder addCharacteristic(String name, String value) {
        CommunicationRequestCharacteristic communicationRequestCharacteristic = new CommunicationRequestCharacteristic();
        communicationRequestCharacteristic.setName(name);
        communicationRequestCharacteristic.setValue(value);
        this.communicationMessage.getCharacteristic().add(communicationRequestCharacteristic);
        return this;
    }

    public CommunicationMessageBuilder addReceiverEmail(String email) {
        Receiver receiver = new Receiver();
        receiver.setEmail(email);
        this.communicationMessage.getReceiver().add(receiver);
        return this;
    }

    public CommunicationMessageBuilder addSenderId(String id) {
        Sender sender = new Sender();
        sender.setId(id);
        this.communicationMessage.setSender(sender);
        return this;
    }

    public CommunicationMessage build() {
        return this.communicationMessage;
    }

    public CommunicationMessageBuilder(CommunicationMessage communicationMessage, ObjectMapper objectMapper) {
        this.communicationMessage = communicationMessage;
        this.objectMapper = objectMapper;
    }
}

