/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.messaging.communication.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.icthh.xm.commons.messaging.communication.CommunicationMessage;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.topic.service.KafkaTemplateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CommunicationService {
    private static final Logger log = LoggerFactory.getLogger(CommunicationService.class);
    private final KafkaTemplateService kafkaTemplateService;
    private final TenantContextHolder tenantContextHolder;
    private final ObjectMapper objectMapper;
    @Value(value="${application.communication.kafka-communication-queue:communication_%s_queue}")
    private String topicName;

    public void sendEmailEvent(CommunicationMessage message) {
        String serializedMessage = this.convertToString(message);
        this.sendMessage(serializedMessage);
    }

    private void sendMessage(String content) {
        String tenantName = this.tenantContextHolder.getTenantKey();
        String topicFullName = String.format(this.topicName, tenantName);
        log.info("Sending communication message event to kafka-topic = '{}', data = '{}'", (Object)topicFullName, (Object)content);
        this.kafkaTemplateService.send(topicFullName, content);
    }

    private String convertToString(Object object) {
        return this.objectMapper.writeValueAsString(object);
    }

    public CommunicationService(KafkaTemplateService kafkaTemplateService, TenantContextHolder tenantContextHolder, ObjectMapper objectMapper) {
        this.kafkaTemplateService = kafkaTemplateService;
        this.tenantContextHolder = tenantContextHolder;
        this.objectMapper = objectMapper;
    }
}

