/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.mail.provider;

import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;

@Service
public class MailProviderService
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MailProviderService.class);
    private static final String TENANT_NAME = "tenantName";
    private static final String MAIL_PROVIDER_PATH = "/config/tenants/{tenantName}/mail-config.yml";
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final Map<String, JavaMailSender> mailSenderMap = new ConcurrentHashMap<String, JavaMailSender>();
    private final JavaMailSender defaultMailSender;

    public void onInit(String configKey, String configValue) {
        if (this.isListeningConfiguration(configKey)) {
            this.onRefresh(configKey, configValue);
        }
    }

    public void onRefresh(String updatedKey, String config) {
        try {
            String tenant = this.getTenantKey(updatedKey);
            if (StringUtils.isNotEmpty((CharSequence)config)) {
                ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                objectMapper.registerModule((Module)new JavaTimeModule());
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                objectMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
                MailProviderConfig providerConfig = (MailProviderConfig)objectMapper.readValue(config, MailProviderConfig.class);
                this.mailSenderMap.put(tenant, this.createMailSender(providerConfig));
                log.info("Updated MailProvider for tenant {}, by path: {} with config = {}", new Object[]{tenant, updatedKey, providerConfig});
            } else {
                this.mailSenderMap.remove(tenant);
                log.info("Removed MailProvider for tenant {}, by path: {}", (Object)tenant, (Object)updatedKey);
            }
        }
        catch (Exception e) {
            log.error("Error read tenant configuration from path [{}]", (Object)updatedKey, (Object)e);
        }
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return this.matcher.match(MAIL_PROVIDER_PATH, updatedKey);
    }

    public JavaMailSender getJavaMailSender(String tenant) {
        return this.mailSenderMap.getOrDefault(tenant, this.defaultMailSender);
    }

    public boolean isTenantMailSenderExists(String tenant) {
        return this.mailSenderMap.containsKey(tenant);
    }

    private String getTenantKey(String updatedKey) {
        return (String)this.matcher.extractUriTemplateVariables(MAIL_PROVIDER_PATH, updatedKey).get(TENANT_NAME);
    }

    private JavaMailSender createMailSender(MailProviderConfig config) {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(config.getHost());
        if (config.getPort() != null) {
            sender.setPort(config.getPort().intValue());
        }
        sender.setUsername(config.getUsername());
        sender.setPassword(config.getPassword());
        sender.setProtocol(config.getProtocol());
        if (config.getDefaultEncoding() != null) {
            sender.setDefaultEncoding(config.getDefaultEncoding().name());
        }
        if (!config.getProperties().isEmpty()) {
            sender.setJavaMailProperties(this.asProperties(config.getProperties()));
        }
        return sender;
    }

    private Properties asProperties(Map<String, String> source) {
        Properties properties = new Properties();
        properties.putAll(source);
        return properties;
    }

    public MailProviderService(JavaMailSender defaultMailSender) {
        this.defaultMailSender = defaultMailSender;
    }

    @JsonRootName(value="mail-provider")
    private static class MailProviderConfig {
        private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
        private String host;
        private Integer port;
        private String username;
        private String password;
        private String protocol = "smtp";
        private Charset defaultEncoding = DEFAULT_CHARSET;
        private Map<String, String> properties = new HashMap<String, String>();

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public Charset getDefaultEncoding() {
            return this.defaultEncoding;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public void setDefaultEncoding(Charset defaultEncoding) {
            this.defaultEncoding = defaultEncoding;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MailProviderConfig)) {
                return false;
            }
            MailProviderConfig other = (MailProviderConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$port = this.getPort();
            Integer other$port = other.getPort();
            if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$protocol = this.getProtocol();
            String other$protocol = other.getProtocol();
            if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
                return false;
            }
            Charset this$defaultEncoding = this.getDefaultEncoding();
            Charset other$defaultEncoding = other.getDefaultEncoding();
            if (this$defaultEncoding == null ? other$defaultEncoding != null : !((Object)this$defaultEncoding).equals(other$defaultEncoding)) {
                return false;
            }
            Map<String, String> this$properties = this.getProperties();
            Map<String, String> other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MailProviderConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
            Charset $defaultEncoding = this.getDefaultEncoding();
            result = result * 59 + ($defaultEncoding == null ? 43 : ((Object)$defaultEncoding).hashCode());
            Map<String, String> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        public String toString() {
            return "MailProviderService.MailProviderConfig(host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", protocol=" + this.getProtocol() + ", defaultEncoding=" + String.valueOf(this.getDefaultEncoding()) + ", properties=" + String.valueOf(this.getProperties()) + ")";
        }
    }
}

