/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.util;

import com.icthh.xm.commons.logging.config.LoggingConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class MaskingService {
    private final Pattern multilinePattern;
    private final boolean enabled;

    public MaskingService(LoggingConfig.MaskingLogConfiguration maskingLogConfiguration, List<String> defaultMaskPatterns) {
        List<String> maskPatterns = MaskingService.getMaskPatterns(maskingLogConfiguration);
        maskPatterns.addAll(defaultMaskPatterns);
        this.enabled = MaskingService.isEnabled(maskingLogConfiguration);
        this.multilinePattern = Pattern.compile(String.join((CharSequence)"|", maskPatterns), 8);
    }

    private static List<String> getMaskPatterns(LoggingConfig.MaskingLogConfiguration maskingLogConfiguration) {
        List patterns = Optional.ofNullable(maskingLogConfiguration).map(LoggingConfig.MaskingLogConfiguration::getMaskPatterns).orElse(Collections.emptyList());
        return new ArrayList<String>(patterns);
    }

    private static Boolean isEnabled(LoggingConfig.MaskingLogConfiguration maskingLogConfiguration) {
        return Optional.ofNullable(maskingLogConfiguration).map(LoggingConfig.MaskingLogConfiguration::getEnabled).orElse(false);
    }

    public String maskMessage(String message) {
        if (!this.enabled) {
            return message;
        }
        StringBuilder sb = new StringBuilder(message);
        Matcher matcher = this.multilinePattern.matcher(sb);
        while (matcher.find()) {
            IntStream.rangeClosed(1, matcher.groupCount()).forEach(group -> {
                if (matcher.group(group) != null) {
                    IntStream.range(matcher.start(group), matcher.end(group)).forEach(i -> sb.setCharAt(i, '*'));
                }
            });
        }
        return sb.toString();
    }
}

