/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.util;

import com.icthh.xm.commons.logging.LoggingAspectConfig;
import com.icthh.xm.commons.logging.config.LoggingConfig;
import com.icthh.xm.commons.logging.util.AopAnnotationUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogObjectPrinter {
    private static final Logger log = LoggerFactory.getLogger(LogObjectPrinter.class);
    private static final String XM_PACKAGE_NAME = "com.icthh.xm";
    private static final String PASSWORD_MASK = "*****";
    private static final Set<String> MASK_SET = new HashSet<String>();
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final String PRINT_EMPTY_LIST = "[]";
    private static final String PRINT_HIDDEN = "#hidden#";
    private static final String PRINT_QUESTION = "?";
    private static final String PRINT_SEMICOLON = ":";
    private static final String PRINT_EMPTY_METHOD = "?:?";

    private LogObjectPrinter() {
    }

    public static String printException(Throwable throwable) {
        return String.valueOf(throwable);
    }

    public static String printExceptionWithStackInfo(Throwable throwable) {
        StringBuilder out = new StringBuilder();
        LogObjectPrinter.printExceptionWithStackInfo(throwable, out);
        return out.toString();
    }

    private static void printExceptionWithStackInfo(Throwable throwable, StringBuilder out) {
        out.append(throwable);
        if (throwable != null) {
            LogObjectPrinter.appendStackTrace(throwable, out);
            if (throwable.getCause() != null) {
                out.append(" -> ");
                LogObjectPrinter.printExceptionWithStackInfo(throwable.getCause(), out);
            }
        }
    }

    private static void appendStackTrace(Throwable throwable, StringBuilder out) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace == null || stackTrace.length < 1) {
            return;
        }
        out.append(' ').append(stackTrace[0]);
        for (int i = 1; i < stackTrace.length; ++i) {
            String stackTraceLine = String.valueOf(stackTrace[i]);
            if (!stackTrace[i].getClassName().startsWith(XM_PACKAGE_NAME) || stackTraceLine.contains("<generated>")) continue;
            out.append(" ... ").append(stackTraceLine).append("...");
            break;
        }
    }

    @SafeVarargs
    public static <T> String joinUrlPaths(T[] arr, T ... arr2) {
        try {
            Object[] url = ArrayUtils.addAll((Object[])arr, (Object[])arr2);
            String res = StringUtils.join((Object[])url);
            return res == null ? "" : res;
        }
        catch (ArrayStoreException | IllegalArgumentException | IndexOutOfBoundsException e) {
            log.warn("Error while join URL paths from: {}, {}", arr, arr2);
            return "printerror:" + String.valueOf(e);
        }
    }

    public static String getCallMethod(JoinPoint joinPoint) {
        if (joinPoint != null && joinPoint.getSignature() != null) {
            Class declaringType = joinPoint.getSignature().getDeclaringType();
            String className = declaringType != null ? declaringType.getSimpleName() : PRINT_QUESTION;
            String methodName = joinPoint.getSignature().getName();
            return className + PRINT_SEMICOLON + methodName;
        }
        return PRINT_EMPTY_METHOD;
    }

    public static String printInputParams(JoinPoint joinPoint, String ... includeParamNames) {
        try {
            MethodSignature ms;
            Object[] params;
            if (joinPoint == null) {
                return "joinPoint is null";
            }
            Signature signature = joinPoint.getSignature();
            if (!(signature instanceof MethodSignature)) {
                return PRINT_EMPTY_LIST;
            }
            Optional<LoggingAspectConfig> config = AopAnnotationUtils.getConfigAnnotation(joinPoint);
            Object[] includeParams = includeParamNames;
            String[] excludeParams = EMPTY_ARRAY;
            boolean inputCollectionAware = false;
            if (config.isPresent()) {
                if (!config.get().inputDetails()) {
                    return PRINT_HIDDEN;
                }
                inputCollectionAware = config.get().inputCollectionAware();
                if (ArrayUtils.isNotEmpty((Object[])config.get().inputIncludeParams())) {
                    includeParams = config.get().inputIncludeParams();
                }
                if (ArrayUtils.isEmpty((Object[])includeParams) && ArrayUtils.isNotEmpty((Object[])config.get().inputExcludeParams())) {
                    excludeParams = config.get().inputExcludeParams();
                }
            }
            return ArrayUtils.isNotEmpty((Object[])(params = (ms = (MethodSignature)signature).getParameterNames())) ? LogObjectPrinter.renderParams(joinPoint, (String[])params, (String[])includeParams, excludeParams, inputCollectionAware) : PRINT_EMPTY_LIST;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            log.warn("Error while print params: {}, params = {}", (Object)e, (Object)joinPoint.getArgs());
            return "printerror: " + String.valueOf(e);
        }
    }

    public static String printInputParams(JoinPoint joinPoint, LoggingConfig.LogConfiguration.LogInput config) {
        try {
            if (joinPoint == null) {
                return "joinPoint is null";
            }
            if (config == null) {
                return LogObjectPrinter.printInputParams(joinPoint, new String[0]);
            }
            Signature signature = joinPoint.getSignature();
            if (!(signature instanceof MethodSignature)) {
                return PRINT_EMPTY_LIST;
            }
            if (config.getDetails() == null) {
                config.setDetails(true);
            }
            if (config.getCollectionAware() == null) {
                config.setCollectionAware(false);
            }
            if (!config.getDetails().booleanValue()) {
                return PRINT_HIDDEN;
            }
            if (config.getExcludeParams() == null) {
                config.setExcludeParams(List.of());
            }
            if (CollectionUtils.isNotEmpty(config.getIncludeParams())) {
                config.setExcludeParams(List.of());
            } else {
                config.setIncludeParams(List.of());
            }
            MethodSignature ms = (MethodSignature)signature;
            Object[] params = ms.getParameterNames();
            return ArrayUtils.isNotEmpty((Object[])params) ? LogObjectPrinter.renderParams(joinPoint, (String[])params, (String[])config.getIncludeParams().toArray(String[]::new), (String[])config.getExcludeParams().toArray(String[]::new), config.getCollectionAware()) : PRINT_EMPTY_LIST;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            log.warn("Error while print params: {}, params = {}", (Object)e, (Object)joinPoint.getArgs());
            return "printerror: " + String.valueOf(e);
        }
    }

    static String renderParams(JoinPoint joinPoint, String[] params, String[] includeParamNames, String[] excludeParamNames, boolean inputCollectionAware) {
        Set<String> includeSet = LogObjectPrinter.prepareNameSet(includeParamNames);
        Set<String> excludeSet = LogObjectPrinter.prepareNameSet(excludeParamNames);
        ArrayList requestList = new ArrayList();
        Map<String, Object> paramMap = LogObjectPrinter.joinPointToParamMap(joinPoint, params);
        if (!includeSet.isEmpty()) {
            includeSet.stream().filter(paramMap::containsKey).forEach(key -> requestList.add(LogObjectPrinter.buildParam(key, paramMap.get(key), inputCollectionAware)));
        } else if (!excludeSet.isEmpty()) {
            paramMap.forEach((key, value) -> {
                if (!excludeSet.contains(key)) {
                    requestList.add(LogObjectPrinter.buildParam(key, value, inputCollectionAware));
                }
            });
        } else {
            paramMap.forEach((key, value) -> requestList.add(LogObjectPrinter.buildParam(key, value, inputCollectionAware)));
        }
        return StringUtils.join(requestList, (char)',');
    }

    private static Map<String, Object> joinPointToParamMap(JoinPoint joinPoint, String[] params) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        IntStream.range(0, params.length).boxed().forEach(index -> map.put(params[index], joinPoint.getArgs()[index]));
        return map;
    }

    private static Set<String> prepareNameSet(String[] paramNames) {
        return !ArrayUtils.isEmpty((Object[])paramNames) ? new LinkedHashSet<String>(Arrays.asList(paramNames)) : Collections.emptySet();
    }

    private static String buildParam(String name, Object value, boolean inputCollectionAware) {
        StringBuilder builder = new StringBuilder(name).append("=");
        if (MASK_SET.contains(name)) {
            builder.append(PASSWORD_MASK);
        } else if (inputCollectionAware) {
            builder.append(LogObjectPrinter.printCollectionAware(value));
        } else {
            builder.append(LogObjectPrinter.printTypeAware(value));
        }
        return builder.toString();
    }

    public static String printResult(JoinPoint joinPoint, Object object) {
        return LogObjectPrinter.printResult(joinPoint, object, true);
    }

    public static String printResult(JoinPoint joinPoint, Object object, boolean printResultDetail) {
        Optional<LoggingAspectConfig> config = AopAnnotationUtils.getConfigAnnotation(joinPoint);
        boolean resultDetails = printResultDetail;
        boolean resultCollectionAware = true;
        if (config.isPresent()) {
            resultDetails = config.get().resultDetails();
            resultCollectionAware = config.get().resultCollectionAware();
        }
        if (!resultDetails) {
            return PRINT_HIDDEN;
        }
        if (resultCollectionAware) {
            return LogObjectPrinter.printCollectionAware(object);
        }
        return String.valueOf(object);
    }

    public static String printResult(JoinPoint joinPoint, Object object, LoggingConfig.LogConfiguration.LogResult config) {
        if (config == null) {
            return LogObjectPrinter.printResult(joinPoint, object);
        }
        if (config.getResultDetails() == null) {
            config.setResultDetails(true);
        }
        if (config.getResultCollectionAware() == null) {
            config.setResultCollectionAware(false);
        }
        if (!config.getResultDetails().booleanValue()) {
            return PRINT_HIDDEN;
        }
        if (config.getResultCollectionAware().booleanValue()) {
            return LogObjectPrinter.printCollectionAware(object);
        }
        return String.valueOf(object);
    }

    public static String printCollectionAware(Object object) {
        return LogObjectPrinter.printCollectionAware(object, true);
    }

    public static String printCollectionAware(Object object, boolean printBody) {
        if (!printBody) {
            return PRINT_HIDDEN;
        }
        if (object == null) {
            return "null";
        }
        Class<?> clazz = object.getClass();
        if (Collection.class.isAssignableFrom(clazz)) {
            return "[<" + clazz.getSimpleName() + "> size = " + ((Collection)object).size() + "]";
        }
        if (clazz.isArray()) {
            return "[<" + clazz.getSimpleName() + "> length = " + Array.getLength(object) + "]";
        }
        return object.toString();
    }

    private static String printTypeAware(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return Arrays.toString((Object[])value);
        }
        return value.toString();
    }

    public static void logWithLevel(Logger log, Level level, String format, Object ... argArray) {
        switch (level.ordinal()) {
            case 5: {
                break;
            }
            case 0: {
                log.trace(format, argArray);
                break;
            }
            case 1: {
                log.debug(format, argArray);
                break;
            }
            case 2: {
                log.info(format, argArray);
                break;
            }
            case 3: {
                log.warn(format, argArray);
                break;
            }
            case 4: {
                log.error(format, argArray);
            }
        }
    }

    static {
        MASK_SET.add("newPassword");
        MASK_SET.add("password");
        MASK_SET.add("defaultPassword");
        MASK_SET.add("secret");
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        OFF_LOG;

    }
}

