/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.icthh.xm.commons.logging.util.LogObjectPrinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LoggingConfig {
    public static final boolean DEFAULT_LOG_INPUT_DETAILS = true;
    public static final boolean DEFAULT_LOG_INPUT_COLLECTION_AWARE = false;
    public static final boolean DEFAULT_LOG_RESULT_DETAILS = true;
    public static final boolean DEFAULT_LOG_RESULT_COLLECTION_AWARE = false;
    @JsonProperty(value="service")
    private List<LogConfiguration> serviceLoggingConfigs;
    @JsonProperty(value="api")
    private List<LogConfiguration> apiLoggingConfigs;
    @JsonProperty(value="lep")
    private List<LepLogConfiguration> lepLogConfigurations;

    public Map<String, LogConfiguration> buildServiceLoggingConfigs() {
        return this.buildLogConfiguration(this.getServiceLoggingConfigs());
    }

    public Map<String, LogConfiguration> buildApiLoggingConfigs() {
        return this.buildLogConfiguration(this.getApiLoggingConfigs());
    }

    public Map<String, LepLogConfiguration> buildLepLoggingConfigs(String tenantKey, String appName) {
        List<LepLogConfiguration> lepLogConfigurations = this.getLepLogConfigurations();
        if (CollectionUtils.isEmpty(lepLogConfigurations)) {
            return Collections.emptyMap();
        }
        return lepLogConfigurations.stream().collect(Collectors.toMap(configuration -> configuration.buildConfigKey(tenantKey, appName), configuration -> configuration));
    }

    private Map<String, LogConfiguration> buildLogConfiguration(List<LogConfiguration> logConfigurations) {
        HashMap<String, LogConfiguration> configs = new HashMap<String, LogConfiguration>();
        if (CollectionUtils.isEmpty(logConfigurations)) {
            return configs;
        }
        return logConfigurations.stream().collect(Collectors.toMap(LogConfiguration::buildConfigKey, configuration -> configuration));
    }

    public List<LogConfiguration> getServiceLoggingConfigs() {
        return this.serviceLoggingConfigs;
    }

    public List<LogConfiguration> getApiLoggingConfigs() {
        return this.apiLoggingConfigs;
    }

    public List<LepLogConfiguration> getLepLogConfigurations() {
        return this.lepLogConfigurations;
    }

    @JsonProperty(value="service")
    public void setServiceLoggingConfigs(List<LogConfiguration> serviceLoggingConfigs) {
        this.serviceLoggingConfigs = serviceLoggingConfigs;
    }

    @JsonProperty(value="api")
    public void setApiLoggingConfigs(List<LogConfiguration> apiLoggingConfigs) {
        this.apiLoggingConfigs = apiLoggingConfigs;
    }

    @JsonProperty(value="lep")
    public void setLepLogConfigurations(List<LepLogConfiguration> lepLogConfigurations) {
        this.lepLogConfigurations = lepLogConfigurations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoggingConfig)) {
            return false;
        }
        LoggingConfig other = (LoggingConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<LogConfiguration> this$serviceLoggingConfigs = this.getServiceLoggingConfigs();
        List<LogConfiguration> other$serviceLoggingConfigs = other.getServiceLoggingConfigs();
        if (this$serviceLoggingConfigs == null ? other$serviceLoggingConfigs != null : !((Object)this$serviceLoggingConfigs).equals(other$serviceLoggingConfigs)) {
            return false;
        }
        List<LogConfiguration> this$apiLoggingConfigs = this.getApiLoggingConfigs();
        List<LogConfiguration> other$apiLoggingConfigs = other.getApiLoggingConfigs();
        if (this$apiLoggingConfigs == null ? other$apiLoggingConfigs != null : !((Object)this$apiLoggingConfigs).equals(other$apiLoggingConfigs)) {
            return false;
        }
        List<LepLogConfiguration> this$lepLogConfigurations = this.getLepLogConfigurations();
        List<LepLogConfiguration> other$lepLogConfigurations = other.getLepLogConfigurations();
        return !(this$lepLogConfigurations == null ? other$lepLogConfigurations != null : !((Object)this$lepLogConfigurations).equals(other$lepLogConfigurations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoggingConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<LogConfiguration> $serviceLoggingConfigs = this.getServiceLoggingConfigs();
        result = result * 59 + ($serviceLoggingConfigs == null ? 43 : ((Object)$serviceLoggingConfigs).hashCode());
        List<LogConfiguration> $apiLoggingConfigs = this.getApiLoggingConfigs();
        result = result * 59 + ($apiLoggingConfigs == null ? 43 : ((Object)$apiLoggingConfigs).hashCode());
        List<LepLogConfiguration> $lepLogConfigurations = this.getLepLogConfigurations();
        result = result * 59 + ($lepLogConfigurations == null ? 43 : ((Object)$lepLogConfigurations).hashCode());
        return result;
    }

    public String toString() {
        return "LoggingConfig(serviceLoggingConfigs=" + this.getServiceLoggingConfigs() + ", apiLoggingConfigs=" + this.getApiLoggingConfigs() + ", lepLogConfigurations=" + this.getLepLogConfigurations() + ")";
    }

    public static class LepLogConfiguration {
        private String group;
        private String fileName;
        private LogObjectPrinter.Level level;

        String buildConfigKey(String tenantKey, String appName) {
            return "lep://" + tenantKey.toUpperCase() + "/" + appName + "/lep/" + this.getGroup() + "/" + this.getFileName();
        }

        public String getGroup() {
            return this.group;
        }

        public String getFileName() {
            return this.fileName;
        }

        public LogObjectPrinter.Level getLevel() {
            return this.level;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setLevel(LogObjectPrinter.Level level) {
            this.level = level;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LepLogConfiguration)) {
                return false;
            }
            LepLogConfiguration other = (LepLogConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            LogObjectPrinter.Level this$level = this.getLevel();
            LogObjectPrinter.Level other$level = other.getLevel();
            return !(this$level == null ? other$level != null : !((Object)((Object)this$level)).equals((Object)other$level));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LepLogConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            LogObjectPrinter.Level $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : ((Object)((Object)$level)).hashCode());
            return result;
        }

        public String toString() {
            return "LoggingConfig.LepLogConfiguration(group=" + this.getGroup() + ", fileName=" + this.getFileName() + ", level=" + this.getLevel() + ")";
        }
    }

    public static class LogConfiguration {
        private String className;
        private String methodName;
        private String packageName;
        private LogObjectPrinter.Level level;
        private LogInput logInput = new LogInput();
        private LogResult logResult = new LogResult();

        String buildConfigKey() {
            Object key = this.getClassName();
            if (StringUtils.isNotBlank((CharSequence)this.getPackageName())) {
                key = this.getPackageName() + ":" + (String)key;
            }
            if (StringUtils.isNotBlank((CharSequence)this.getMethodName())) {
                key = (String)key + ":" + this.getMethodName();
            }
            return key;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public LogObjectPrinter.Level getLevel() {
            return this.level;
        }

        public LogInput getLogInput() {
            return this.logInput;
        }

        public LogResult getLogResult() {
            return this.logResult;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public void setLevel(LogObjectPrinter.Level level) {
            this.level = level;
        }

        public void setLogInput(LogInput logInput) {
            this.logInput = logInput;
        }

        public void setLogResult(LogResult logResult) {
            this.logResult = logResult;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogConfiguration)) {
                return false;
            }
            LogConfiguration other = (LogConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            String this$packageName = this.getPackageName();
            String other$packageName = other.getPackageName();
            if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
                return false;
            }
            LogObjectPrinter.Level this$level = this.getLevel();
            LogObjectPrinter.Level other$level = other.getLevel();
            if (this$level == null ? other$level != null : !((Object)((Object)this$level)).equals((Object)other$level)) {
                return false;
            }
            LogInput this$logInput = this.getLogInput();
            LogInput other$logInput = other.getLogInput();
            if (this$logInput == null ? other$logInput != null : !((Object)this$logInput).equals(other$logInput)) {
                return false;
            }
            LogResult this$logResult = this.getLogResult();
            LogResult other$logResult = other.getLogResult();
            return !(this$logResult == null ? other$logResult != null : !((Object)this$logResult).equals(other$logResult));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LogConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            String $packageName = this.getPackageName();
            result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
            LogObjectPrinter.Level $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : ((Object)((Object)$level)).hashCode());
            LogInput $logInput = this.getLogInput();
            result = result * 59 + ($logInput == null ? 43 : ((Object)$logInput).hashCode());
            LogResult $logResult = this.getLogResult();
            result = result * 59 + ($logResult == null ? 43 : ((Object)$logResult).hashCode());
            return result;
        }

        public String toString() {
            return "LoggingConfig.LogConfiguration(className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ", packageName=" + this.getPackageName() + ", level=" + this.getLevel() + ", logInput=" + this.getLogInput() + ", logResult=" + this.getLogResult() + ")";
        }

        public static class LogInput {
            private Boolean details = true;
            private Boolean collectionAware = false;
            private List<String> includeParams = new ArrayList<String>();
            private List<String> excludeParams = new ArrayList<String>();

            public Boolean getDetails() {
                return this.details;
            }

            public Boolean getCollectionAware() {
                return this.collectionAware;
            }

            public List<String> getIncludeParams() {
                return this.includeParams;
            }

            public List<String> getExcludeParams() {
                return this.excludeParams;
            }

            public void setDetails(Boolean details) {
                this.details = details;
            }

            public void setCollectionAware(Boolean collectionAware) {
                this.collectionAware = collectionAware;
            }

            public void setIncludeParams(List<String> includeParams) {
                this.includeParams = includeParams;
            }

            public void setExcludeParams(List<String> excludeParams) {
                this.excludeParams = excludeParams;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LogInput)) {
                    return false;
                }
                LogInput other = (LogInput)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$details = this.getDetails();
                Boolean other$details = other.getDetails();
                if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
                    return false;
                }
                Boolean this$collectionAware = this.getCollectionAware();
                Boolean other$collectionAware = other.getCollectionAware();
                if (this$collectionAware == null ? other$collectionAware != null : !((Object)this$collectionAware).equals(other$collectionAware)) {
                    return false;
                }
                List<String> this$includeParams = this.getIncludeParams();
                List<String> other$includeParams = other.getIncludeParams();
                if (this$includeParams == null ? other$includeParams != null : !((Object)this$includeParams).equals(other$includeParams)) {
                    return false;
                }
                List<String> this$excludeParams = this.getExcludeParams();
                List<String> other$excludeParams = other.getExcludeParams();
                return !(this$excludeParams == null ? other$excludeParams != null : !((Object)this$excludeParams).equals(other$excludeParams));
            }

            protected boolean canEqual(Object other) {
                return other instanceof LogInput;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $details = this.getDetails();
                result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
                Boolean $collectionAware = this.getCollectionAware();
                result = result * 59 + ($collectionAware == null ? 43 : ((Object)$collectionAware).hashCode());
                List<String> $includeParams = this.getIncludeParams();
                result = result * 59 + ($includeParams == null ? 43 : ((Object)$includeParams).hashCode());
                List<String> $excludeParams = this.getExcludeParams();
                result = result * 59 + ($excludeParams == null ? 43 : ((Object)$excludeParams).hashCode());
                return result;
            }

            public String toString() {
                return "LoggingConfig.LogConfiguration.LogInput(details=" + this.getDetails() + ", collectionAware=" + this.getCollectionAware() + ", includeParams=" + this.getIncludeParams() + ", excludeParams=" + this.getExcludeParams() + ")";
            }
        }

        public static class LogResult {
            private Boolean resultDetails = true;
            private Boolean resultCollectionAware = false;

            public Boolean getResultDetails() {
                return this.resultDetails;
            }

            public Boolean getResultCollectionAware() {
                return this.resultCollectionAware;
            }

            public void setResultDetails(Boolean resultDetails) {
                this.resultDetails = resultDetails;
            }

            public void setResultCollectionAware(Boolean resultCollectionAware) {
                this.resultCollectionAware = resultCollectionAware;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LogResult)) {
                    return false;
                }
                LogResult other = (LogResult)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$resultDetails = this.getResultDetails();
                Boolean other$resultDetails = other.getResultDetails();
                if (this$resultDetails == null ? other$resultDetails != null : !((Object)this$resultDetails).equals(other$resultDetails)) {
                    return false;
                }
                Boolean this$resultCollectionAware = this.getResultCollectionAware();
                Boolean other$resultCollectionAware = other.getResultCollectionAware();
                return !(this$resultCollectionAware == null ? other$resultCollectionAware != null : !((Object)this$resultCollectionAware).equals(other$resultCollectionAware));
            }

            protected boolean canEqual(Object other) {
                return other instanceof LogResult;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $resultDetails = this.getResultDetails();
                result = result * 59 + ($resultDetails == null ? 43 : ((Object)$resultDetails).hashCode());
                Boolean $resultCollectionAware = this.getResultCollectionAware();
                result = result * 59 + ($resultCollectionAware == null ? 43 : ((Object)$resultCollectionAware).hashCode());
                return result;
            }

            public String toString() {
                return "LoggingConfig.LogConfiguration.LogResult(resultDetails=" + this.getResultDetails() + ", resultCollectionAware=" + this.getResultCollectionAware() + ")";
            }
        }
    }
}

