/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.spi.ContextAwareBase;
import net.logstash.logback.appender.LogstashUdpSocketAppender;
import net.logstash.logback.layout.LogstashLayout;
import net.logstash.logback.stacktrace.ShortenedThrowableConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogstashConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogstashConfigurer.class);

    public static void initLogstash(XmLogstashConfig config) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        LogstashConfigurer.addLogstashAppender(context, config);
        context.addListener((LoggerContextListener)new LogbackLoggerContextListener(context, config));
    }

    private static void addLogstashAppender(LoggerContext context, XmLogstashConfig config) {
        LOGGER.info("Initializing Logstash logging");
        LogstashUdpSocketAppender logstashAppender = new LogstashUdpSocketAppender();
        LogstashLayout layout = new LogstashLayout();
        logstashAppender.setLayout((Layout)layout);
        logstashAppender.setName("LOGSTASH");
        logstashAppender.setContext((Context)context);
        String customFields = "{\"app_name\":\"" + config.getAppName() + "\",\"app_port\":\"" + config.getAppPort() + "\",\"instance_id\":\"" + config.getInstanceId() + "\"}";
        logstashAppender.setSyslogHost(config.getLogstashHost());
        logstashAppender.setPort(config.getLogstashPort());
        layout.setCustomFields(customFields);
        ShortenedThrowableConverter throwableConverter = new ShortenedThrowableConverter();
        throwableConverter.setMaxLength(7500);
        throwableConverter.setRootCauseFirst(true);
        layout.setThrowableConverter((ThrowableHandlingConverter)throwableConverter);
        logstashAppender.start();
        AsyncAppender asyncLogstashAppender = new AsyncAppender();
        asyncLogstashAppender.setContext((Context)context);
        asyncLogstashAppender.setName("ASYNC_LOGSTASH");
        asyncLogstashAppender.setQueueSize(config.getLogstashQueueSize());
        asyncLogstashAppender.addAppender((Appender)logstashAppender);
        asyncLogstashAppender.start();
        context.getLogger("ROOT").addAppender((Appender)asyncLogstashAppender);
    }

    private LogstashConfigurer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class XmLogstashConfig {
        private String appName;
        private int appPort;
        private String instanceId;
        private String logstashHost;
        private int logstashPort;
        private int logstashQueueSize;

        public String getAppName() {
            return this.appName;
        }

        public int getAppPort() {
            return this.appPort;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public String getLogstashHost() {
            return this.logstashHost;
        }

        public int getLogstashPort() {
            return this.logstashPort;
        }

        public int getLogstashQueueSize() {
            return this.logstashQueueSize;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public void setAppPort(int appPort) {
            this.appPort = appPort;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public void setLogstashHost(String logstashHost) {
            this.logstashHost = logstashHost;
        }

        public void setLogstashPort(int logstashPort) {
            this.logstashPort = logstashPort;
        }

        public void setLogstashQueueSize(int logstashQueueSize) {
            this.logstashQueueSize = logstashQueueSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XmLogstashConfig)) {
                return false;
            }
            XmLogstashConfig other = (XmLogstashConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAppPort() != other.getAppPort()) {
                return false;
            }
            if (this.getLogstashPort() != other.getLogstashPort()) {
                return false;
            }
            if (this.getLogstashQueueSize() != other.getLogstashQueueSize()) {
                return false;
            }
            String this$appName = this.getAppName();
            String other$appName = other.getAppName();
            if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
                return false;
            }
            String this$instanceId = this.getInstanceId();
            String other$instanceId = other.getInstanceId();
            if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
                return false;
            }
            String this$logstashHost = this.getLogstashHost();
            String other$logstashHost = other.getLogstashHost();
            return !(this$logstashHost == null ? other$logstashHost != null : !this$logstashHost.equals(other$logstashHost));
        }

        protected boolean canEqual(Object other) {
            return other instanceof XmLogstashConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAppPort();
            result = result * 59 + this.getLogstashPort();
            result = result * 59 + this.getLogstashQueueSize();
            String $appName = this.getAppName();
            result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
            String $instanceId = this.getInstanceId();
            result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
            String $logstashHost = this.getLogstashHost();
            result = result * 59 + ($logstashHost == null ? 43 : $logstashHost.hashCode());
            return result;
        }

        public String toString() {
            return "LogstashConfigurer.XmLogstashConfig(appName=" + this.getAppName() + ", appPort=" + this.getAppPort() + ", instanceId=" + this.getInstanceId() + ", logstashHost=" + this.getLogstashHost() + ", logstashPort=" + this.getLogstashPort() + ", logstashQueueSize=" + this.getLogstashQueueSize() + ")";
        }

        public XmLogstashConfig(String appName, int appPort, String instanceId, String logstashHost, int logstashPort, int logstashQueueSize) {
            this.appName = appName;
            this.appPort = appPort;
            this.instanceId = instanceId;
            this.logstashHost = logstashHost;
            this.logstashPort = logstashPort;
            this.logstashQueueSize = logstashQueueSize;
        }
    }

    static class LogbackLoggerContextListener
    extends ContextAwareBase
    implements LoggerContextListener {
        private final XmLogstashConfig config;

        private LogbackLoggerContextListener(LoggerContext context, XmLogstashConfig config) {
            this.setContext((Context)context);
            this.config = config;
        }

        public boolean isResetResistant() {
            return true;
        }

        public void onStart(LoggerContext context) {
            LogstashConfigurer.addLogstashAppender(context, this.config);
        }

        public void onReset(LoggerContext context) {
            LogstashConfigurer.addLogstashAppender(context, this.config);
        }

        public void onStop(LoggerContext context) {
        }

        public void onLevelChange(ch.qos.logback.classic.Logger logger, Level level) {
        }
    }
}

