/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.aop;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import com.icthh.xm.commons.logging.aop.MaskedLoggingEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SecurityMaskingConsoleAppender
extends ConsoleAppender<ILoggingEvent> {
    private final List<String> keywords = new ArrayList<String>();
    private String replacementMessage;

    public void addKeyword(String keyword) {
        if (keyword != null && !keyword.isBlank()) {
            this.keywords.add(keyword.toLowerCase(Locale.ROOT));
        }
    }

    public void setKeywords(String keywords) {
        if (keywords == null || keywords.isBlank()) {
            return;
        }
        for (String k : keywords.split(",")) {
            this.addKeyword(k.trim());
        }
    }

    public void setReplacementMessage(String replacementMessage) {
        this.replacementMessage = replacementMessage;
    }

    protected void append(ILoggingEvent eventObject) {
        ILoggingEvent toLog = this.applyMasking(eventObject);
        super.append((Object)toLog);
    }

    ILoggingEvent applyMasking(ILoggingEvent original) {
        if (original == null) {
            return null;
        }
        String msg = original.getFormattedMessage();
        if (msg == null) {
            msg = original.getMessage();
        }
        if (this.containsSensitive(msg)) {
            return new MaskedLoggingEvent(original, this.replacementMessage);
        }
        return original;
    }

    private boolean containsSensitive(String msg) {
        if (msg == null || this.keywords.isEmpty()) {
            return false;
        }
        String lowerMsg = msg.toLowerCase(Locale.ROOT);
        for (String keyword : this.keywords) {
            if (!lowerMsg.contains(keyword)) continue;
            return true;
        }
        return false;
    }
}

