/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.aop;

import com.icthh.xm.commons.logging.config.LoggingConfig;
import com.icthh.xm.commons.logging.config.LoggingConfigService;
import com.icthh.xm.commons.logging.util.LogObjectPrinter;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Aspect
@Order(value=-2147483646)
public class ServiceLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(ServiceLoggingAspect.class);
    private static final String XM_BASE_PACKAGE = "com.icthh.xm";
    private static final String LOG_START_PATTERN = "srv:start: {}, input: {}";
    private static final String LOG_STOP_PATTERN = "srv:stop:  {}, result: {}, time = {} ms";
    private static final String LOG_ERROR_PATTERN = "srv:stop:  {}, error: {}, time = {} ms";
    private final LoggingConfigService loggingConfigService;
    @Value(value="${base-package:'-'}")
    private String basePackage;

    @Pointcut(value="@annotation(com.icthh.xm.commons.logging.aop.IgnoreLogginAspect) || within(@com.icthh.xm.commons.logging.aop.IgnoreLogginAspect *)")
    public void excluded() {
    }

    @Pointcut(value="(within(@org.springframework.stereotype.Service *) || within(@com.icthh.xm.commons.lep.*.LepService *))")
    public void servicePointcut() {
    }

    @Around(value="servicePointcut() && !excluded()")
    public Object logBeforeService(ProceedingJoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        String className = signature.getDeclaringTypeName();
        if (!this.withLogging(className)) {
            return joinPoint.proceed();
        }
        Class declaringType = signature.getDeclaringType();
        className = declaringType.getSimpleName();
        String packageName = declaringType.getPackageName();
        String methodName = signature.getName();
        LoggingConfig.LogConfiguration config = this.loggingConfigService.getServiceLoggingConfig(packageName, className, methodName);
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            this.logStart((JoinPoint)joinPoint, config);
            Object result = joinPoint.proceed();
            this.logStop((JoinPoint)joinPoint, result, stopWatch, config);
            return result;
        }
        catch (Exception e) {
            this.logError((JoinPoint)joinPoint, e, stopWatch);
            throw e;
        }
    }

    private boolean withLogging(String className) {
        return className.startsWith(XM_BASE_PACKAGE) || className.startsWith(this.basePackage);
    }

    private void logStart(JoinPoint joinPoint, LoggingConfig.LogConfiguration config) {
        String callMethod = LogObjectPrinter.getCallMethod(joinPoint);
        if (config == null) {
            log.info(LOG_START_PATTERN, (Object)callMethod, (Object)LogObjectPrinter.printInputParams(joinPoint, new String[0]));
            return;
        }
        if (LogObjectPrinter.Level.OFF_LOG.equals((Object)config.getLevel())) {
            return;
        }
        LogObjectPrinter.logWithLevel(log, config.getLevel(), LOG_START_PATTERN, callMethod, LogObjectPrinter.printInputParams(joinPoint, config.getLogInput()));
    }

    private void logStop(JoinPoint joinPoint, Object result, StopWatch stopWatch, LoggingConfig.LogConfiguration config) {
        String callMethod = LogObjectPrinter.getCallMethod(joinPoint);
        if (config == null) {
            log.info(LOG_STOP_PATTERN, new Object[]{callMethod, LogObjectPrinter.printResult(joinPoint, result), stopWatch.getTime(TimeUnit.MILLISECONDS)});
            return;
        }
        if (LogObjectPrinter.Level.OFF_LOG.equals((Object)config.getLevel())) {
            return;
        }
        LogObjectPrinter.logWithLevel(log, config.getLevel(), LOG_STOP_PATTERN, callMethod, LogObjectPrinter.printResult(joinPoint, result, config.getLogResult()), stopWatch.getTime(TimeUnit.MILLISECONDS));
    }

    private void logError(JoinPoint joinPoint, Throwable e, StopWatch stopWatch) {
        log.error(LOG_ERROR_PATTERN, new Object[]{LogObjectPrinter.getCallMethod(joinPoint), LogObjectPrinter.printExceptionWithStackInfo(e), stopWatch.getTime(TimeUnit.MILLISECONDS)});
    }

    public ServiceLoggingAspect(LoggingConfigService loggingConfigService) {
        this.loggingConfigService = loggingConfigService;
    }
}

