/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.aop;

import com.icthh.xm.commons.logging.util.LogObjectPrinter;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Aspect
@Order(value=-2147483646)
public class ServiceLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(ServiceLoggingAspect.class);
    private static final String XM_BASE_PACKAGE = "com.icthh.xm";
    @Value(value="${base-package:'-'}")
    private String basePackage;

    @Pointcut(value="@annotation(com.icthh.xm.commons.logging.aop.IgnoreLogginAspect) || within(@com.icthh.xm.commons.logging.aop.IgnoreLogginAspect *)")
    public void excluded() {
    }

    @Pointcut(value="(within(@org.springframework.stereotype.Service *) || within(@com.icthh.xm.commons.lep.*.LepService *))")
    public void servicePointcut() {
    }

    @Around(value="servicePointcut() && !excluded()")
    public Object logBeforeService(ProceedingJoinPoint joinPoint) {
        String className = joinPoint.getSignature().getDeclaringTypeName();
        if (!this.withLogging(className)) {
            return joinPoint.proceed();
        }
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            this.logStart((JoinPoint)joinPoint);
            Object result = joinPoint.proceed();
            this.logStop((JoinPoint)joinPoint, result, stopWatch);
            return result;
        }
        catch (Exception e) {
            this.logError((JoinPoint)joinPoint, e, stopWatch);
            throw e;
        }
    }

    private boolean withLogging(String className) {
        return className.startsWith(XM_BASE_PACKAGE) || className.startsWith(this.basePackage);
    }

    private void logStart(JoinPoint joinPoint) {
        log.info("srv:start: {}, input: {}", (Object)LogObjectPrinter.getCallMethod(joinPoint), (Object)LogObjectPrinter.printInputParams(joinPoint, new String[0]));
    }

    private void logStop(JoinPoint joinPoint, Object result, StopWatch stopWatch) {
        log.info("srv:stop:  {}, result: {}, time = {} ms", new Object[]{LogObjectPrinter.getCallMethod(joinPoint), LogObjectPrinter.printResult(joinPoint, result), stopWatch.getTime(TimeUnit.MILLISECONDS)});
    }

    private void logError(JoinPoint joinPoint, Throwable e, StopWatch stopWatch) {
        log.error("srv:stop:  {}, error: {}, time = {} ms", new Object[]{LogObjectPrinter.getCallMethod(joinPoint), LogObjectPrinter.printExceptionWithStackInfo(e), stopWatch.getTime(TimeUnit.MILLISECONDS)});
    }
}

