/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.web.rest;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.icthh.xm.commons.logging.web.rest.vm.LoggerVm;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/management"})
public class LogsResource {
    @GetMapping(value={"/logs"})
    public List<LoggerVm> getList() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        return context.getLoggerList().stream().map(LoggerVm::new).collect(Collectors.toList());
    }

    @PutMapping(value={"/logs"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void changeLevel(@RequestBody LoggerVm jsonLogger) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.getLogger(jsonLogger.getName()).setLevel(Level.valueOf((String)jsonLogger.getLevel()));
    }
}

