/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.web.aop;

import com.icthh.xm.commons.logging.util.LogObjectPrinter;
import com.icthh.xm.commons.logging.web.util.WebLogObjectPrinter;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class RestCallLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(RestCallLoggingAspect.class);

    @Pointcut(value="within(org.springframework.web.client.RestTemplate)")
    public void restTemplatePointcut() {
    }

    @Around(value="restTemplatePointcut()")
    public Object logBeforeRest(ProceedingJoinPoint joinPoint) throws Throwable {
        StopWatch stopWatch = StopWatch.createStarted();
        String uri = null;
        String calledApi = null;
        try {
            uri = LogObjectPrinter.printInputParams((JoinPoint)joinPoint, (String[])new String[]{"method", "url"});
            calledApi = LogObjectPrinter.getCallMethod((JoinPoint)joinPoint);
            log.info("rest:start {} --> {}", (Object)calledApi, (Object)uri);
            Object result = joinPoint.proceed();
            log.info("rest:stop  {} --> {}, {}, time = {} ms", new Object[]{calledApi, uri, WebLogObjectPrinter.printRestResult((JoinPoint)joinPoint, result, false), stopWatch.getTime(TimeUnit.MILLISECONDS)});
            return result;
        }
        catch (Exception e) {
            log.error("rest:stop  {} --> request = {}, error = {}, time = {} ms", new Object[]{calledApi, LogObjectPrinter.printInputParams((JoinPoint)joinPoint, (String[])new String[0]), LogObjectPrinter.printExceptionWithStackInfo((Throwable)e), stopWatch.getTime(TimeUnit.MILLISECONDS)});
            throw e;
        }
    }
}

