/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.trace;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.stereotype.Component;

@Component
public class MicrometerWrapper {
    private static final Logger log = LoggerFactory.getLogger(MicrometerWrapper.class);
    private static final String TIMER_NAME = "kafka.processing.timer";
    private static final String SPAN_NAME_FROM_MESSAGE = "on-message";
    private final Tracer tracer;
    private final MeterRegistry meterRegistry;

    @Autowired
    public MicrometerWrapper(Tracer tracer, MeterRegistry meterRegistry) {
        this.tracer = tracer;
        this.meterRegistry = meterRegistry;
    }

    public void runWithMicrometer(ConsumerRecord<?, ?> record, Runnable codeToRun) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithMicrometer(Message<?> message, MessageChannel channel, Runnable codeToRun) {
        Timer.Sample timerSample = Timer.start((MeterRegistry)this.meterRegistry);
        Object exceptionFromExecution = null;
        try {
            codeToRun.run();
        }
        finally {
            timerSample.stop(this.meterRegistry.timer(TIMER_NAME, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithExistingSpan(Span existingSpan, Runnable codeToRun) {
        log.trace("Opening span, {}", (Object)existingSpan.context().spanId());
        try (Tracer.SpanInScope spanInScope = this.tracer.withSpan(existingSpan);){
            codeToRun.run();
        }
        finally {
            log.trace("Closing span, {}", (Object)existingSpan.context().spanId());
            existingSpan.end();
        }
    }
}

