/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.trace;

import com.icthh.xm.commons.lep.spring.ApplicationLepProcessingEvent;
import com.icthh.xm.lep.api.LepManager;
import com.icthh.xm.lep.api.LepProcessingEvent;
import com.icthh.xm.lep.api.ScopedContext;
import org.springframework.cloud.sleuth.instrument.web.mvc.TracingClientHttpRequestInterceptor;
import org.springframework.context.ApplicationListener;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.stereotype.Component;

@Component
public class TraceService
implements ApplicationListener<ApplicationLepProcessingEvent> {
    private final LepManager lepManager;
    private final TracingClientHttpRequestInterceptor tracingClientHttpRequestInterceptor;

    public void onApplicationEvent(ApplicationLepProcessingEvent event) {
        if (event.getLepProcessingEvent() instanceof LepProcessingEvent.BeforeExecutionEvent) {
            ScopedContext context = this.lepManager.getContext("lep.system.execution");
            context.setValue("traceService", (Object)this);
        }
    }

    public ClientHttpRequestInterceptor getTraceInterceptor() {
        return this.tracingClientHttpRequestInterceptor;
    }

    public TraceService(LepManager lepManager, TracingClientHttpRequestInterceptor tracingClientHttpRequestInterceptor) {
        this.lepManager = lepManager;
        this.tracingClientHttpRequestInterceptor = tracingClientHttpRequestInterceptor;
    }
}

