/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.configurable;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import com.icthh.xm.commons.logging.config.LoggingConfigService;
import com.icthh.xm.commons.logging.util.MaskingLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@Order(value=-2147483648)
public class LogMaskingConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LogMaskingConfiguration.class);

    public LogMaskingConfiguration(LoggingConfigService loggingConfigService) {
        log.info("Init MaskingPatternLayout");
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.getLogger("ROOT").iteratorForAppenders().forEachRemaining(it -> {
            OutputStreamAppender appender;
            Encoder encoder;
            if (it instanceof OutputStreamAppender && (encoder = (appender = (OutputStreamAppender)it).getEncoder()) instanceof LayoutWrappingEncoder) {
                LayoutWrappingEncoder layoutEncoder = (LayoutWrappingEncoder)encoder;
                Layout layout = layoutEncoder.getLayout();
                LayoutWrappingEncoder maskingEncoder = new LayoutWrappingEncoder();
                maskingEncoder.setLayout((Layout)new MaskingLayout(layout, loggingConfigService));
                maskingEncoder.setContext((Context)context);
                maskingEncoder.setCharset(layoutEncoder.getCharset());
                maskingEncoder.start();
                appender.setEncoder((Encoder)maskingEncoder);
            }
        });
    }
}

