/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.logging.configurable;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.logging.config.LoggingConfig;
import com.icthh.xm.commons.logging.config.LoggingConfigService;
import com.icthh.xm.commons.logging.util.MaskingService;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import com.icthh.xm.commons.tenant.TenantKey;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

@Component
@Primary
public class LoggingRefreshableConfiguration
implements RefreshableConfiguration,
LoggingConfigService {
    private static final Logger log = LoggerFactory.getLogger(LoggingRefreshableConfiguration.class);
    private final MaskingService NULL_MASKING_SERVICE;
    private final Map<String, Map<String, LoggingConfig.LogConfiguration>> serviceLoggingConfig = new ConcurrentHashMap<String, Map<String, LoggingConfig.LogConfiguration>>();
    private final Map<String, Map<String, LoggingConfig.LogConfiguration>> apiLoggingConfig = new ConcurrentHashMap<String, Map<String, LoggingConfig.LogConfiguration>>();
    private final Map<String, Map<String, LoggingConfig.LepLogConfiguration>> lepLoggingConfig = new ConcurrentHashMap<String, Map<String, LoggingConfig.LepLogConfiguration>>();
    private final Map<String, MaskingService> maskingConfig = new ConcurrentHashMap<String, MaskingService>();
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final ObjectMapper ymlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final TenantContextHolder tenantContextHolder;
    private final String mappingPath;
    private final String appName;
    private final List<String> maskPatterns;

    public LoggingRefreshableConfiguration(TenantContextHolder tenantContextHolder, @Value(value="${spring.application.name}") String appName, @Value(value="${application.maskPatterns:#{T(java.util.Collections).emptyList()}}") List<String> maskPatterns) {
        this.tenantContextHolder = tenantContextHolder;
        this.mappingPath = "/config/tenants/{tenantName}/" + appName + "/logging.yml";
        this.appName = appName;
        this.maskPatterns = maskPatterns;
        LoggingConfig.MaskingLogConfiguration maskingLogConfiguration = new LoggingConfig.MaskingLogConfiguration();
        maskingLogConfiguration.setEnabled(Boolean.valueOf(!maskPatterns.isEmpty()));
        this.NULL_MASKING_SERVICE = new MaskingService(maskingLogConfiguration, maskPatterns);
    }

    public void onRefresh(String updatedKey, String config) {
        try {
            String tenant = (String)this.matcher.extractUriTemplateVariables(this.mappingPath, updatedKey).get("tenantName");
            if (StringUtils.isBlank((CharSequence)config)) {
                this.apiLoggingConfig.remove(tenant);
                this.serviceLoggingConfig.remove(tenant);
                this.lepLoggingConfig.remove(tenant);
                return;
            }
            LoggingConfig spec = (LoggingConfig)this.ymlMapper.readValue(config, LoggingConfig.class);
            this.serviceLoggingConfig.put(tenant, spec.buildServiceLoggingConfigs());
            this.apiLoggingConfig.put(tenant, spec.buildApiLoggingConfigs());
            this.lepLoggingConfig.put(tenant, spec.buildLepLoggingConfigs(tenant, this.appName));
            this.maskingConfig.put(tenant, new MaskingService(spec.getMasking(), this.maskPatterns));
            log.info("Tenant configuration was updated for tenant [{}] by key [{}]", (Object)tenant, (Object)updatedKey);
        }
        catch (Exception e) {
            log.error("Error read tenant configuration from path " + updatedKey, (Throwable)e);
        }
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return this.matcher.match(this.mappingPath, updatedKey);
    }

    public void onInit(String configKey, String configValue) {
        if (this.isListeningConfiguration(configKey)) {
            this.onRefresh(configKey, configValue);
        }
    }

    public MaskingService getMaskingService() {
        return TenantContextUtils.getTenantKey((TenantContextHolder)this.tenantContextHolder).map(TenantKey::getValue).map(this.maskingConfig::get).orElse(this.NULL_MASKING_SERVICE);
    }

    public LoggingConfig.LogConfiguration getServiceLoggingConfig(String packageName, String className, String methodName) {
        return TenantContextUtils.getTenantKey((TenantContextHolder)this.tenantContextHolder).map(TenantKey::getValue).map(this.serviceLoggingConfig::get).map(config -> this.getLogConfiguration((Map<String, LoggingConfig.LogConfiguration>)config, packageName, className, methodName)).orElse(null);
    }

    public LoggingConfig.LogConfiguration getApiLoggingConfig(String packageName, String className, String methodName) {
        return TenantContextUtils.getTenantKey((TenantContextHolder)this.tenantContextHolder).map(TenantKey::getValue).map(this.apiLoggingConfig::get).map(config -> this.getLogConfiguration((Map<String, LoggingConfig.LogConfiguration>)config, packageName, className, methodName)).orElse(null);
    }

    public LoggingConfig.LepLogConfiguration getLepLoggingConfig(String fileName) {
        if (fileName == null) {
            return null;
        }
        return TenantContextUtils.getTenantKey((TenantContextHolder)this.tenantContextHolder).map(TenantKey::getValue).map(this.lepLoggingConfig::get).filter(MapUtils::isNotEmpty).map(config -> (LoggingConfig.LepLogConfiguration)config.get(fileName)).orElse(null);
    }

    private LoggingConfig.LogConfiguration getLogConfiguration(Map<String, LoggingConfig.LogConfiguration> logConfiguration, String packageName, String className, String methodName) {
        if (MapUtils.isEmpty(logConfiguration)) {
            return null;
        }
        LoggingConfig.LogConfiguration configuration = logConfiguration.get(packageName + ":" + className + ":" + methodName);
        if (configuration == null) {
            configuration = logConfiguration.get(className + ":" + methodName);
        }
        if (configuration == null) {
            configuration = logConfiguration.get(className);
        }
        return configuration;
    }
}

