/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.privilege;

import com.icthh.xm.commons.domain.spec.FunctionSpec;
import com.icthh.xm.commons.permission.service.custom.CustomPrivilegesExtractor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DynamicCustomPrivilegesExtractor
implements CustomPrivilegesExtractor<FunctionSpec> {
    private static final Logger log = LoggerFactory.getLogger(DynamicCustomPrivilegesExtractor.class);
    private final String appName;
    private final boolean enabled;
    private static final String SECTION_NAME = "-functions";
    private static final String PRIVILEGE_PREFIX = "FUNCTION.CALL.";

    public DynamicCustomPrivilegesExtractor(@Value(value="${spring.application.name}") String appName, @Value(value="${application.dynamic-permission-check.enabled:true}") boolean enabled) {
        this.appName = appName;
        this.enabled = enabled;
    }

    public String getSectionName() {
        return this.appName + SECTION_NAME;
    }

    public String getPrivilegePrefix() {
        return PRIVILEGE_PREFIX;
    }

    public List<String> toPrivilegesList(Collection<FunctionSpec> specs) {
        return specs.stream().filter(Objects::nonNull).map(FunctionSpec::getKey).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public boolean isEnabled(String tenantKey) {
        return this.enabled;
    }
}

