/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.rest;

import com.codahale.metrics.annotation.Timed;
import com.icthh.xm.commons.permission.annotation.PrivilegeDescription;
import com.icthh.xm.commons.swagger.DynamicSwaggerFunctionGenerator;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class FunctionApiDocsResource {
    private static final Logger log = LoggerFactory.getLogger(FunctionApiDocsResource.class);
    private static final String X_DOMAIN = "x-domain";
    private static final String X_PORT = "x-port";
    public static final String PROTOCOL = "https://";
    private final DynamicSwaggerFunctionGenerator functionDocService;

    @Timed
    @GetMapping(value={"/functions/api-docs"})
    @PrivilegeDescription(value="Privilege to get openapi documentation for functions api")
    public ResponseEntity<Object> callGetFunction(HttpServletRequest request) {
        String url = PROTOCOL + request.getHeader(X_DOMAIN) + ":" + request.getHeader(X_PORT);
        return ResponseEntity.ok().body((Object)this.functionDocService.generateSwagger(url));
    }

    public FunctionApiDocsResource(DynamicSwaggerFunctionGenerator functionDocService) {
        this.functionDocService = functionDocService;
    }
}

