/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config;

import com.icthh.xm.commons.config.DataSpecificationService;
import com.icthh.xm.commons.config.FunctionApiSpecsProcessor;
import com.icthh.xm.commons.domain.FunctionSpecWithFileName;
import com.icthh.xm.commons.domain.comparator.FunctionSpecPathComparator;
import com.icthh.xm.commons.domain.spec.FunctionApiSpecs;
import com.icthh.xm.commons.domain.spec.FunctionSpec;
import com.icthh.xm.commons.listener.JsonListenerService;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.service.SpecificationProcessingService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@IgnoreLogginAspect
public class FunctionApiSpecConfiguration
extends DataSpecificationService<FunctionApiSpecs> {
    private static final Logger log = LoggerFactory.getLogger(FunctionApiSpecConfiguration.class);
    private final String appName;

    public FunctionApiSpecConfiguration(@Value(value="${spring.application.name}") String appName, JsonListenerService jsonListenerService, FunctionApiSpecsProcessor functionApiSpecsProcessor) {
        super(FunctionApiSpecs.class, jsonListenerService, (SpecificationProcessingService)functionApiSpecsProcessor);
        this.appName = appName;
    }

    public String specKey() {
        return "functions";
    }

    public String folder() {
        return this.appName + "/functions";
    }

    public Optional<FunctionSpec> getSpecByKeyAndTenant(String functionKey, String tenantKey) {
        return this.getTenantSpecifications(tenantKey).values().stream().map(FunctionApiSpecs::getItems).filter(Objects::nonNull).flatMap(Collection::stream).filter(f -> functionKey.equals(f.getKey())).findFirst();
    }

    public Collection<FunctionSpec> getOrderedSpecByTenant(String tenantKey) {
        return this.getTenantSpecifications(tenantKey).values().stream().map(FunctionApiSpecs::getItems).filter(Objects::nonNull).flatMap(Collection::stream).sorted(FunctionSpecPathComparator.of()).toList();
    }

    public Collection<FunctionSpecWithFileName<FunctionSpec>> getFunctionSpecsWithFileName(String tenantKey) {
        Map<String, FunctionApiSpecs> specificationsMap = this.getSpecificationsMapFromFiles(tenantKey);
        return specificationsMap.entrySet().stream().filter(e -> Objects.nonNull(e.getValue())).filter(e -> Objects.nonNull(((FunctionApiSpecs)e.getValue()).getItems())).flatMap(e -> ((FunctionApiSpecs)e.getValue()).getItems().stream().map(f -> new FunctionSpecWithFileName<FunctionSpec>((FunctionSpec)f, this.extractFileName(tenantKey, (Map.Entry<String, FunctionApiSpecs>)e)))).toList();
    }

    private String extractFileName(String tenantKey, Map.Entry<String, FunctionApiSpecs> e) {
        String prefix = this.getSpecFolder(tenantKey) + "/";
        if (Objects.nonNull(e.getKey()) && e.getKey().endsWith(".yml") && e.getKey().startsWith(prefix)) {
            return e.getKey().substring(prefix.length(), e.getKey().lastIndexOf(46));
        }
        return null;
    }

    public String getSpecFolder(String tenantKey) {
        return "/config/tenants/" + tenantKey + "/" + this.folder();
    }

    protected Map<String, FunctionApiSpecs> getSpecificationsMapFromFiles(String tenantKey) {
        Map fileToSpec = super.getSpecificationsMapFromFiles(tenantKey);
        fileToSpec.entrySet().stream().filter(e -> Objects.nonNull(e.getValue())).filter(e -> Objects.nonNull(((FunctionApiSpecs)e.getValue()).getItems())).filter(e -> Objects.nonNull(this.extractFileName(tenantKey, (Map.Entry<String, FunctionApiSpecs>)e))).forEach(e -> {
            String fileKey = this.extractFileName(tenantKey, (Map.Entry<String, FunctionApiSpecs>)e);
            ((FunctionApiSpecs)e.getValue()).getItems().stream().filter(item -> CollectionUtils.isEmpty(item.getTags())).forEach(item -> item.setTags(List.of(fileKey)));
        });
        return fileToSpec;
    }
}

