/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.swagger;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.config.swagger.DynamicSwaggerConfiguration;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

@Component
public class DynamicSwaggerRefreshableConfiguration
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DynamicSwaggerRefreshableConfiguration.class);
    private final ObjectMapper objectMapper;
    private final AntPathMatcher matcher;
    private final String specPath;
    private final Map<String, DynamicSwaggerConfiguration> config;
    private final TenantContextHolder tenantContextHolder;

    public DynamicSwaggerRefreshableConfiguration(@Value(value="${spring.application.name}") String appName, TenantContextHolder tenantContextHolder) {
        this.specPath = "/config/tenants/{tenantName}/" + appName + "/swagger.yml";
        this.tenantContextHolder = tenantContextHolder;
        this.objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.matcher = new AntPathMatcher();
        this.config = new ConcurrentHashMap<String, DynamicSwaggerConfiguration>();
    }

    public void onRefresh(String updatedKey, String config) {
        try {
            String tenant = (String)this.matcher.extractUriTemplateVariables(this.specPath, updatedKey).get("tenantName");
            if (StringUtils.isBlank((CharSequence)config)) {
                this.config.remove(tenant);
                log.info("Configuration was removed for tenant [{}] by key [{}]", (Object)tenant, (Object)updatedKey);
            } else {
                this.config.put(tenant, (DynamicSwaggerConfiguration)this.objectMapper.readValue(config, DynamicSwaggerConfiguration.class));
                log.info("Configuration was updated for tenant [{}] by key [{}]", (Object)tenant, (Object)updatedKey);
            }
        }
        catch (Exception e) {
            log.error("Error read configuration from path {}", (Object)updatedKey, (Object)e);
        }
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return this.matcher.match(this.specPath, updatedKey);
    }

    public DynamicSwaggerConfiguration getConfiguration() {
        return this.config.get(this.tenantContextHolder.getTenantKey());
    }
}

