/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config;

import com.icthh.xm.commons.config.DataSpecificationService;
import com.icthh.xm.commons.config.FunctionApiSpecsProcessor;
import com.icthh.xm.commons.domain.comparator.FunctionSpecPathComparator;
import com.icthh.xm.commons.domain.spec.FunctionApiSpecs;
import com.icthh.xm.commons.domain.spec.FunctionSpec;
import com.icthh.xm.commons.listener.JsonListenerService;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.service.SpecificationProcessingService;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@IgnoreLogginAspect
public class FunctionApiSpecConfiguration
extends DataSpecificationService<FunctionApiSpecs> {
    private static final Logger log = LoggerFactory.getLogger(FunctionApiSpecConfiguration.class);
    private final String appName;

    public FunctionApiSpecConfiguration(@Value(value="${spring.application.name}") String appName, JsonListenerService jsonListenerService, FunctionApiSpecsProcessor functionApiSpecsProcessor) {
        super(FunctionApiSpecs.class, jsonListenerService, (SpecificationProcessingService)functionApiSpecsProcessor);
        this.appName = appName;
    }

    public String specKey() {
        return "functions";
    }

    public String folder() {
        return this.appName + "/functions";
    }

    public Optional<FunctionSpec> getSpecByKeyAndTenant(String functionKey, String tenantKey) {
        return this.getTenantSpecifications(tenantKey).values().stream().map(FunctionApiSpecs::getItems).filter(Objects::nonNull).flatMap(Collection::stream).filter(f -> functionKey.equals(f.getKey())).findFirst();
    }

    public Collection<FunctionSpec> getOrderedSpecByTenant(String tenantKey) {
        return this.getTenantSpecifications(tenantKey).values().stream().map(FunctionApiSpecs::getItems).filter(Objects::nonNull).flatMap(Collection::stream).sorted(FunctionSpecPathComparator.of()).toList();
    }
}

