/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.swagger.impl;

import com.icthh.xm.commons.config.swagger.DynamicSwaggerConfiguration;
import com.icthh.xm.commons.config.swagger.DynamicSwaggerRefreshableConfiguration;
import com.icthh.xm.commons.domain.spec.IFunctionSpec;
import com.icthh.xm.commons.swagger.DynamicSwaggerFunctionGenerator;
import com.icthh.xm.commons.swagger.SwaggerGenerator;
import com.icthh.xm.commons.swagger.model.SwaggerFunction;
import com.icthh.xm.commons.swagger.model.SwaggerModel;
import com.icthh.xm.commons.swagger.model.SwaggerParameter;
import com.icthh.xm.commons.utils.SwaggerGeneratorUtils;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

public abstract class AbstractDynamicSwaggerFunctionGenerator<FS extends IFunctionSpec>
implements DynamicSwaggerFunctionGenerator {
    private final DynamicSwaggerRefreshableConfiguration dynamicSwaggerService;

    public AbstractDynamicSwaggerFunctionGenerator(DynamicSwaggerRefreshableConfiguration dynamicSwaggerService) {
        this.dynamicSwaggerService = dynamicSwaggerService;
    }

    public DynamicSwaggerConfiguration getSwaggerConfiguration() {
        return this.dynamicSwaggerService.getConfiguration();
    }

    @Override
    public SwaggerModel generateSwagger(String baseUrl) {
        DynamicSwaggerConfiguration swaggerConfig = this.getSwaggerConfiguration();
        return this.generateSwagger(baseUrl, this.getFunctionSpecs(swaggerConfig));
    }

    public SwaggerModel generateSwagger(String baseUrl, List<FS> functionSpecs) {
        SwaggerGenerator swaggerGenerator = this.getSwaggerGenerator(baseUrl);
        functionSpecs.forEach(it -> this.generateSwaggerFunction(it, swaggerGenerator));
        SwaggerModel swaggerBody = swaggerGenerator.getSwaggerBody();
        this.enrichSwaggerBody(swaggerBody);
        return swaggerBody;
    }

    private void generateSwaggerFunction(FS functionSpec, SwaggerGenerator defaultSwaggerGenerator) {
        String prefix = this.buildPathPrefix(functionSpec);
        Map<String, SwaggerParameter> pathPrefixParams = this.buildPrefixPathParams(functionSpec);
        defaultSwaggerGenerator.generateFunction(prefix, pathPrefixParams, this.buildSwaggerFunction(functionSpec));
    }

    private SwaggerFunction buildSwaggerFunction(FS functionSpec) {
        SwaggerFunction swaggerFunction = new SwaggerFunction(functionSpec.getKey(), SwaggerGeneratorUtils.makeAsPath(functionSpec.getPath(), functionSpec.getKey()), this.getFunctionName(functionSpec), this.getFunctionDescription(functionSpec), this.getFunctionInputJsonSchema(functionSpec), this.getFunctionOutputJsonSchema(functionSpec), this.getFunctionTags(functionSpec), this.getFunctionHttpMethods(functionSpec), functionSpec.getWrapResult(), functionSpec.getAnonymous());
        this.enrichSwaggerFunction(functionSpec, swaggerFunction);
        return swaggerFunction;
    }

    public abstract void enrichSwaggerBody(SwaggerModel var1);

    public abstract void enrichSwaggerFunction(FS var1, SwaggerFunction var2);

    public abstract SwaggerGenerator getSwaggerGenerator(String var1);

    public abstract List<FS> getFunctionSpecs(DynamicSwaggerConfiguration var1);

    @NotNull
    public abstract String buildPathPrefix(FS var1);

    @NotNull
    public abstract Map<String, SwaggerParameter> buildPrefixPathParams(FS var1);

    @NotNull
    public abstract List<String> getFunctionHttpMethods(FS var1);

    @NotNull
    public abstract List<String> getFunctionTags(FS var1);

    public abstract String getFunctionName(FS var1);

    public abstract String getFunctionDescription(FS var1);

    public abstract String getFunctionInputJsonSchema(FS var1);

    public abstract String getFunctionOutputJsonSchema(FS var1);
}

