/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.swagger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.icthh.xm.commons.exceptions.BusinessException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaToSwaggerSchemaConverter {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaToSwaggerSchemaConverter.class);
    private static final Set<String> supportedKeywords = Set.of("$ref", "definitions", "title", "pattern", "required", "enum", "minimum", "maximum", "exclusiveMinimum", "exclusiveMaximum", "multipleOf", "minLength", "maxLength", "minItems", "maxItems", "uniqueItems", "minProperties", "maxProperties", "type", "format", "description", "items", "properties", "additionalProperties", "default", "allOf", "oneOf", "anyOf", "not", "deprecated", "discriminator", "example", "externalDocs", "nullable", "readOnly", "writeOnly", "xml");
    private static final Set<String> validTypes = Set.of("null", "boolean", "object", "array", "number", "string", "integer");
    public static final String COMPONENTS_SCHEMAS = "#/components/schemas/";
    public final ObjectMapper objectMapper = new ObjectMapper();
    private final String definitionSectionName;
    private final Set<String> definitionPrefixes;

    public JsonSchemaToSwaggerSchemaConverter() {
        this("xmDefinition", Set.of("definitions", "xmDefinition"));
    }

    public JsonSchemaToSwaggerSchemaConverter(String definitionSectionName, Set<String> definitionPrefixes) {
        this.definitionSectionName = definitionSectionName;
        this.definitionPrefixes = definitionPrefixes;
    }

    public String transformToSwaggerJson(String typeName, String jsonSchema, Map<String, Object> definitions, Map<String, Object> originalDefinitions) {
        JsonNode json = this.transformToJsonNode(typeName, jsonSchema, definitions, originalDefinitions);
        return this.writeJson(json);
    }

    public JsonNode transformToJsonNode(String typeName, String jsonSchema, Map<String, Object> definitions, Map<String, Object> originalDefinitions) {
        if (StringUtils.isBlank((CharSequence)jsonSchema)) {
            return JsonNodeFactory.instance.nullNode();
        }
        JsonNode inputJson = this.readJson(jsonSchema);
        if (!inputJson.isObject()) {
            throw new IllegalArgumentException("Json schema should be an object");
        }
        ObjectNode json = (ObjectNode)inputJson;
        if (!(json.has("type") || json.has("properties") || json.has("$ref"))) {
            this.removeEmptyDefinition(json);
            ObjectNode object = JsonSchemaToSwaggerSchemaConverter.object("type", (JsonNode)JsonNodeFactory.instance.textNode("object"));
            object.set("properties", (JsonNode)json);
            json = object;
        }
        if (json.has("properties") && !json.has("type")) {
            this.removeEmptyDefinition(json);
            json.put("type", "object");
        }
        this.transformToSwaggerJson(typeName, json, definitions, originalDefinitions, JsonNodeFactory.instance.objectNode());
        return json;
    }

    private void removeEmptyDefinition(ObjectNode json) {
        if (json.has(this.definitionSectionName) && json.get(this.definitionSectionName).isObject() && json.get(this.definitionSectionName).isEmpty()) {
            json.remove(this.definitionSectionName);
        }
    }

    private void transformToSwaggerJson(String typeName, ObjectNode json, Map<String, Object> definitions, Map<String, Object> originalDefinitions, ObjectNode objectDefinitions) {
        if (!json.isObject()) {
            return;
        }
        this.processDefinitions(typeName, json, definitions, originalDefinitions, objectDefinitions);
        this.traverseSchema((JsonNode)JsonNodeFactory.instance.nullNode(), typeName, (JsonNode)json, (TriConsumer<JsonNode, String, ObjectNode>)((TriConsumer)this::convertElement));
        this.traverseSchema((JsonNode)JsonNodeFactory.instance.nullNode(), typeName, (JsonNode)json, (TriConsumer<JsonNode, String, ObjectNode>)((TriConsumer)this::rewriteUnsupportedKeywords));
    }

    private void traverseSchema(JsonNode parent, String fieldName, JsonNode json, TriConsumer<JsonNode, String, ObjectNode> convertElement) {
        if (json == null) {
            return;
        }
        if (json.isArray()) {
            int index = 0;
            json.forEach(it -> this.traverseSchema(json, fieldName + "__" + index, (JsonNode)it, convertElement));
        } else if (json.isObject()) {
            this.convert(parent, fieldName, json, convertElement);
            json.fields().forEachRemaining(it -> this.traverseSchema(json, (String)it.getKey(), (JsonNode)it.getValue(), convertElement));
        }
    }

    private void convert(JsonNode parent, String fieldName, JsonNode json, TriConsumer<JsonNode, String, ObjectNode> function) {
        if (json == null || !json.isObject()) {
            return;
        }
        function.accept((Object)parent, (Object)fieldName, (Object)((ObjectNode)json));
    }

    private void convertElement(JsonNode parent, String fieldName, ObjectNode object) {
        this.fixArrayDeclarations(object);
        this.convertNullable(parent, fieldName, object);
        this.rewriteConst(object);
        this.rewriteIfThenElse(object);
        this.rewriteExclusiveMinMax(object);
        this.convertDependencies(parent, fieldName, object);
        this.removeEmptyRequired(object);
    }

    private void fixArrayDeclarations(ObjectNode object) {
        if (object.has("type") && object.get("type").asText().equals("array") && object.has("items") && object.get("items").isArray() && object.get("items").size() == 1) {
            object.set("items", object.get("items").get(0));
        }
    }

    private void removeEmptyRequired(ObjectNode object) {
        if (object.has("required") && object.get("required").isArray() && object.get("required").isEmpty()) {
            object.remove("required");
        }
    }

    private void convertDependencies(JsonNode parent, String fieldName, ObjectNode schema) {
        if (this.insideProperties(parent, fieldName)) {
            return;
        }
        JsonNode deps = schema.get("dependencies");
        if (deps == null || !deps.isObject()) {
            return;
        }
        schema.remove("dependencies");
        ArrayNode allOf = schema.has("allOf") && schema.get("allOf").isArray() ? (ArrayNode)schema.get("allOf") : schema.putArray("allOf");
        deps.fields().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            ArrayList<Object> requiredArray = new ArrayList<Object>();
            requiredArray.add(schema.textNode(key));
            if (value.isArray()) {
                for (JsonNode item : value) {
                    requiredArray.add(item);
                }
            } else {
                requiredArray.add(value);
            }
            ObjectNode allOfItem = JsonSchemaToSwaggerSchemaConverter.object("oneOf", (JsonNode)JsonSchemaToSwaggerSchemaConverter.array(List.of(JsonSchemaToSwaggerSchemaConverter.object("not", (JsonNode)JsonSchemaToSwaggerSchemaConverter.object("required", (JsonNode)JsonSchemaToSwaggerSchemaConverter.array(List.of(schema.textNode(key))))), JsonSchemaToSwaggerSchemaConverter.object("required", (JsonNode)JsonSchemaToSwaggerSchemaConverter.array(requiredArray)))));
            allOf.add((JsonNode)allOfItem);
        });
    }

    private void rewriteUnsupportedKeywords(JsonNode parent, String parentFieldName, ObjectNode json) {
        if (this.insideProperties(parent, parentFieldName)) {
            return;
        }
        ArrayList<String> toRewrite = new ArrayList<String>();
        Iterator fieldNames = json.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName2 = (String)fieldNames.next();
            if (supportedKeywords.contains(fieldName2) || fieldName2.startsWith("x-")) continue;
            toRewrite.add(fieldName2);
        }
        toRewrite.forEach(fieldName -> json.set("x-" + fieldName, json.remove(fieldName)));
    }

    private boolean insideProperties(JsonNode parent, String parentFieldName) {
        return parentFieldName.equals("properties") && parent.has("type") && parent.get("type").asText().equals("object");
    }

    private void processDefinitions(String typeName, ObjectNode json, Map<String, Object> definitions, Map<String, Object> originalDefinitions, ObjectNode objectDefinitions) {
        for (String definitionsField : this.definitionPrefixes) {
            if (!json.has(definitionsField)) continue;
            objectDefinitions.set(definitionsField, json.remove(definitionsField));
        }
        this.traverseSchema((JsonNode)JsonNodeFactory.instance.nullNode(), typeName, (JsonNode)json, (TriConsumer<JsonNode, String, ObjectNode>)((TriConsumer)(parent, fieldName, object) -> {
            if (object.has("$ref")) {
                String ref = object.get("$ref").asText();
                Optional<String> definitionField = this.definitionPrefixes.stream().map(it -> "#/" + it + "/").filter(ref::startsWith).findFirst();
                if (definitionField.isEmpty()) {
                    return;
                }
                String typePath = ref.substring(definitionField.get().length());
                JsonNode currentNode = this.readByPath(ref, objectDefinitions);
                String definitionName = this.getDefinitionName(typeName, originalDefinitions, typePath, currentNode);
                if (currentNode != null && currentNode.isObject()) {
                    ObjectNode definitionNode = (ObjectNode)currentNode.deepCopy();
                    definitions.put(definitionName, definitionNode);
                    originalDefinitions.put(definitionName, definitionNode.deepCopy());
                    object.put("$ref", COMPONENTS_SCHEMAS + definitionName);
                    this.transformToSwaggerJson(definitionName, definitionNode, definitions, originalDefinitions, objectDefinitions);
                }
            }
        }));
    }

    private JsonNode readByPath(String ref, ObjectNode objectNode) {
        String path = ref.replace("#/", "");
        ObjectNode currentNode = objectNode;
        for (String field : path.split("/")) {
            if (!currentNode.has(field)) {
                log.warn("Definition not found: {}", (Object)ref);
                currentNode = null;
                break;
            }
            currentNode = currentNode.get(field);
        }
        return currentNode;
    }

    private String getDefinitionName(String typeName, Map<String, Object> definitions, String path, JsonNode currentNode) {
        int i;
        String[] segments = path.split("/");
        Object uniqKey = "";
        for (i = segments.length - 1; i >= 0; --i) {
            uniqKey = StringUtils.capitalize((String)segments[i]) + (String)uniqKey;
            if (JsonSchemaToSwaggerSchemaConverter.containsDefinition(definitions, currentNode, (String)uniqKey)) continue;
            return uniqKey;
        }
        if (!JsonSchemaToSwaggerSchemaConverter.containsDefinition(definitions, currentNode, (String)uniqKey)) {
            return uniqKey;
        }
        uniqKey = StringUtils.capitalize((String)typeName) + (String)uniqKey;
        i = 1;
        Object tempKey = uniqKey;
        while (JsonSchemaToSwaggerSchemaConverter.containsDefinition(definitions, currentNode, (String)uniqKey)) {
            tempKey = (String)uniqKey + i;
            ++i;
        }
        return tempKey;
    }

    private static boolean containsDefinition(Map<String, Object> definitions, JsonNode currentNode, String uniqKey) {
        return definitions.get(uniqKey) != null && !definitions.get(uniqKey).equals(currentNode);
    }

    private void validateTypes(JsonNode parent, String fieldName, JsonNode typeBlock) {
        JsonNode type = typeBlock.get("type");
        if (type.has("properties") || type.has("type") || type.has("anyOf") || type.has("oneOf")) {
            return;
        }
        if (this.insideProperties(parent, fieldName)) {
            return;
        }
        if (type.has("$ref")) {
            String ref = type.get("$ref").asText();
            if (this.definitionPrefixes.stream().map(it -> "#/" + it + "/").noneMatch(ref::startsWith)) {
                throw new BusinessException("error.invalid.json.type.ref", "Invalid ref: " + ref, Map.of("json", typeBlock.toString(), "fieldName", fieldName));
            }
            return;
        }
        if (type.isArray()) {
            type.forEach(it -> {
                if (!validTypes.contains(it.asText())) {
                    throw new BusinessException("error.invalid.json.type", "Invalid type: " + it.asText(), Map.of("json", typeBlock.toString(), "fieldName", fieldName));
                }
            });
            return;
        }
        if (!validTypes.contains(type.asText())) {
            throw new BusinessException("error.invalid.json.type", "Invalid type: " + type.asText(), Map.of("json", typeBlock.toString(), "fieldName", fieldName));
        }
    }

    private Object convertNullable(JsonNode parent, String fieldName, ObjectNode json) {
        JsonNode type = json.get("type");
        if (type == null) {
            return json;
        }
        this.validateTypes(parent, fieldName, (JsonNode)json);
        if (type.isNull() || type.asText().equals("null")) {
            json.remove("type");
            json.put("nullable", true);
            return json;
        }
        if (type.asText().equals("array") && !json.has("items")) {
            json.putObject("items");
        }
        if (type.isArray()) {
            ArrayNode typeArrayNode = (ArrayNode)type;
            Iterator elements = typeArrayNode.elements();
            while (elements.hasNext()) {
                JsonNode it2 = (JsonNode)elements.next();
                if (!it2.isNull() && !it2.asText().equals("null")) continue;
                elements.remove();
                json.put("nullable", true);
            }
            if (typeArrayNode.isEmpty()) {
                json.remove("type");
            } else if (typeArrayNode.size() == 1) {
                json.set("type", typeArrayNode.get(0));
            } else if (typeArrayNode.size() > 1) {
                List items = IteratorUtils.toList((Iterator)typeArrayNode.elements());
                List types = items.stream().map(it -> JsonSchemaToSwaggerSchemaConverter.object("type", it)).collect(Collectors.toList());
                json.set("anyOf", (JsonNode)JsonSchemaToSwaggerSchemaConverter.array(types));
                json.remove("type");
            }
        }
        return json;
    }

    private void rewriteConst(ObjectNode jsonNode) {
        if (jsonNode.has("const") && jsonNode.get("const").isValueNode()) {
            JsonNode value = jsonNode.get("const");
            if (value.isNumber()) {
                jsonNode.put("type", "number");
            } else if (value.isTextual()) {
                jsonNode.put("type", "string");
            } else if (value.isBoolean()) {
                jsonNode.put("type", "boolean");
            }
            jsonNode.set("enum", (JsonNode)JsonSchemaToSwaggerSchemaConverter.array(List.of(value)));
            jsonNode.remove("const");
        }
    }

    private void rewriteIfThenElse(ObjectNode json) {
        if (json.has("if") && json.has("than")) {
            json.set("oneOf", (JsonNode)JsonSchemaToSwaggerSchemaConverter.array(List.of(JsonSchemaToSwaggerSchemaConverter.object("allOf", (JsonNode)JsonSchemaToSwaggerSchemaConverter.array(List.of(json.get("if"), json.get("then")))), JsonSchemaToSwaggerSchemaConverter.object("allOf", (JsonNode)JsonSchemaToSwaggerSchemaConverter.array(List.of(json.get("if"), json.get("else")))))));
        }
    }

    private void rewriteExclusiveMinMax(ObjectNode json) {
        if (json.has("type") && (json.get("type").asText().equals("number") || json.get("type").asText().equals("integer"))) {
            if (json.has("exclusiveMinimum") && json.get("exclusiveMinimum").isNumber()) {
                json.set("minimum", json.get("exclusiveMinimum"));
                json.put("exclusiveMinimum", true);
            }
            if (json.has("exclusiveMaximum") && json.get("exclusiveMaximum").isNumber()) {
                json.set("maximum", json.get("exclusiveMaximum"));
                json.put("exclusiveMaximum", true);
            }
        }
    }

    private static ArrayNode array(List<? extends JsonNode> items) {
        items = items.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return JsonNodeFactory.instance.arrayNode().addAll(items);
    }

    private static ObjectNode object(String type, JsonNode it) {
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
        objectNode.set(type, it);
        return objectNode;
    }

    private String writeJson(Object jsonSchema) {
        return this.objectMapper.writeValueAsString(jsonSchema);
    }

    private JsonNode readJson(String jsonSchema) {
        return this.objectMapper.readTree(jsonSchema);
    }

    public void inlineRootRef(JsonNode jsonNode, Map<String, Object> definitions) {
        if (!(jsonNode instanceof ObjectNode)) {
            return;
        }
        if (jsonNode.has("$ref")) {
            this.inlineRef(jsonNode.get("$ref").asText(), (ObjectNode)jsonNode, definitions);
        } else if (jsonNode.has("properties") && jsonNode.get("properties").has("$ref")) {
            this.inlineRef(jsonNode.get("properties").get("$ref").asText(), (ObjectNode)jsonNode.get("properties"), definitions);
        }
    }

    private void inlineRef(String ref, ObjectNode jsonNode, Map<String, Object> definitions) {
        if (!ref.startsWith(COMPONENTS_SCHEMAS)) {
            return;
        }
        Object refNode = definitions.get(ref = ref.substring(COMPONENTS_SCHEMAS.length()));
        if (!(refNode instanceof ObjectNode)) {
            return;
        }
        ObjectNode refObject = (ObjectNode)refNode;
        refObject.fields().forEachRemaining(entry -> jsonNode.set((String)entry.getKey(), ((JsonNode)entry.getValue()).deepCopy()));
    }
}

