/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.utils;

import com.icthh.xm.commons.config.swagger.DynamicSwaggerConfiguration;
import com.icthh.xm.commons.domain.spec.FunctionSpec;
import com.icthh.xm.commons.utils.CollectionsUtils;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public final class FunctionSpecUtils {
    private static final Logger log = LoggerFactory.getLogger(FunctionSpecUtils.class);

    public static boolean filterAndLogByHttpMethod(String httpMethod, FunctionSpec functionSpec) {
        if (FunctionSpecUtils.filterByHttpMethod(httpMethod, functionSpec)) {
            return true;
        }
        log.error("Function {} not found for http method {}", (Object)functionSpec.getKey(), (Object)httpMethod);
        return false;
    }

    public static boolean filterByHttpMethod(String httpMethod, FunctionSpec functionSpec) {
        return CollectionUtils.isEmpty(functionSpec.getHttpMethods()) || functionSpec.getHttpMethods().contains(httpMethod);
    }

    public static Predicate<? super FunctionSpec> byFilters(DynamicSwaggerConfiguration swaggerConfig) {
        if (swaggerConfig == null) {
            return functionSpec -> true;
        }
        List<String> includeTags = CollectionsUtils.nullSafe(swaggerConfig.getIncludeTags());
        List<String> includePaths = CollectionsUtils.nullSafe(swaggerConfig.getIncludePathPatterns());
        List<String> includeKeys = CollectionsUtils.nullSafe(swaggerConfig.getIncludeKeyPatterns());
        List<String> excludeTags = CollectionsUtils.nullSafe(swaggerConfig.getExcludeTags());
        List<String> excludeKeys = CollectionsUtils.nullSafe(swaggerConfig.getExcludeKeyPatterns());
        List<String> excludePaths = CollectionsUtils.nullSafe(swaggerConfig.getExcludePathPatterns());
        return functionSpec -> {
            boolean matchesInclude = includeTags.isEmpty() && includePaths.isEmpty() && includeKeys.isEmpty() || FunctionSpecUtils.checkFilters(functionSpec, includeTags, includePaths, includeKeys);
            boolean matchesExclude = FunctionSpecUtils.checkFilters(functionSpec, excludeTags, excludePaths, excludeKeys);
            return matchesInclude && !matchesExclude;
        };
    }

    private static boolean checkFilters(FunctionSpec functionSpec, List<String> tags, List<String> pathPatterns, List<String> keyPatterns) {
        List<String> funcTags = CollectionsUtils.nullSafe(functionSpec.getTags());
        return tags.stream().anyMatch(funcTags::contains) || pathPatterns.stream().anyMatch(it -> functionSpec.getPath().matches((String)it)) || keyPatterns.stream().anyMatch(it -> functionSpec.getKey().matches((String)it));
    }

    private FunctionSpecUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

