/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.service.exporter;

import com.icthh.xm.commons.exceptions.BusinessException;
import com.icthh.xm.commons.service.exporter.ExportService;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ExportServiceProvider {
    private final Set<ExportService> exportServices;

    public ExportService getExportService(String format) {
        return this.exportServices.stream().filter(s -> s.supports(format)).findFirst().orElseThrow(() -> new BusinessException("File format not supported: " + format));
    }

    public ExportServiceProvider(Set<ExportService> exportServices) {
        this.exportServices = exportServices;
    }
}

