/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.service.exporter;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.icthh.xm.commons.domain.BaseRow;
import com.icthh.xm.commons.service.FunctionExecutorService;
import com.icthh.xm.commons.service.exporter.AbstractExportServiceImpl;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

@Component
public class CvsExportService<T extends BaseRow>
extends AbstractExportServiceImpl<T> {
    private static final Logger log = LoggerFactory.getLogger(CvsExportService.class);
    private static final CsvMapper csvMapper = CvsExportService.buildCsvMapper();

    protected CvsExportService(FunctionExecutorService functionExecutorService) {
        super(functionExecutorService);
    }

    @Override
    public boolean supports(String fileFormat) {
        return "csv".equalsIgnoreCase(fileFormat);
    }

    @Override
    public void export(String functionKey, String fileFormat, Map<String, Object> functionInput, HttpServletResponse response) {
        log.info("Start export function key [{}], file format [{}]", (Object)functionKey, (Object)fileFormat);
        try (ServletOutputStream os = response.getOutputStream();){
            int page = 0;
            Page result = this.getNextPage(page, functionKey, functionInput);
            ObjectWriter csvWriter = this.createCsvWriterWithHeaders(result.getContent());
            try (SequenceWriter seqWriter = csvWriter.writeValues((OutputStream)os);){
                while (true) {
                    this.writePageContent(seqWriter, result);
                    if (!result.hasNext()) {
                        break;
                    }
                    result = this.getNextPage(++page, functionKey, functionInput);
                }
            }
        }
        catch (Exception e) {
            log.error("Exception while exporting data to csv file, {}", (Object)e.getMessage());
            throw new IllegalStateException("Exception while exporting data to csv file", e);
        }
    }

    private void writePageContent(SequenceWriter seqWriter, Page<T> page) throws IOException {
        for (BaseRow item : page.getContent()) {
            seqWriter.write(item.getFieldValues());
        }
    }

    private ObjectWriter createCsvWriterWithHeaders(List<T> exportData) {
        List headers = Optional.ofNullable(exportData).filter(data -> !data.isEmpty()).map(d -> ((BaseRow)d.getFirst()).getHeaders()).orElse(List.of());
        CsvSchema.Builder schemaBuilder = CsvSchema.builder();
        headers.forEach(arg_0 -> ((CsvSchema.Builder)schemaBuilder).addColumn(arg_0));
        CsvSchema schema = schemaBuilder.build();
        if (!headers.isEmpty()) {
            schema = schema.withHeader();
        }
        return csvMapper.writer((FormatSchema)schema);
    }

    private static CsvMapper buildCsvMapper() {
        CsvMapper mapper = new CsvMapper();
        mapper.configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true);
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    }
}

