/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.exceptions;

import java.util.HashMap;
import java.util.Map;

public class BusinessException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final String PARAM = "param";
    private final String code;
    private final String message;
    private final Map<String, String> paramMap = new HashMap<String, String>();

    public BusinessException(String message) {
        this("error.business", message);
    }

    public BusinessException(String code, String message) {
        super(message);
        this.code = code;
        this.message = message;
    }

    public BusinessException(String code, String message, Map<String, String> paramMap) {
        super(message);
        this.code = code;
        this.message = message;
        this.paramMap.putAll(paramMap);
    }

    public BusinessException(String message, Map<String, String> paramMap) {
        this(message);
        this.paramMap.putAll(paramMap);
    }

    public BusinessException withParams(String ... params) {
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                this.paramMap.put(PARAM + i, params[i]);
            }
        }
        return this;
    }

    @Override
    public String toString() {
        return "{code=" + this.code + ", message=" + this.message + (String)(this.paramMap.isEmpty() ? "" : ", paramMap=" + String.valueOf(this.paramMap)) + "}";
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getParamMap() {
        return this.paramMap;
    }
}

