/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.processor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.icthh.xm.commons.ObjectMapperUtils;
import com.icthh.xm.commons.domain.DataSpec;
import com.icthh.xm.commons.listener.JsonListenerService;
import com.icthh.xm.commons.processor.SpecProcessor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataSpecProcessor<S extends DataSpec>
extends SpecProcessor<S> {
    private static final Logger log = LoggerFactory.getLogger(DataSpecProcessor.class);

    public DataSpecProcessor(JsonListenerService jsonListenerService) {
        super(jsonListenerService);
    }

    public abstract void processDataSpecReferences(String var1, String var2, String var3, Map<String, Map<String, Object>> var4);

    @Override
    public void processDataSpec(String tenant, String baseSpecKey, Consumer<String> setter, Supplier<String> getter) {
        String dataSpec = getter.get();
        if (io.micrometer.common.util.StringUtils.isBlank((String)dataSpec)) {
            log.debug("Skipped empty data spec for tenant: {}", (Object)tenant);
            return;
        }
        try {
            Map<String, Object> resultSpec = ObjectMapperUtils.deserializeToMap(dataSpec);
            LinkedHashMap<String, Map<String, Object>> tenantDataSpecContententMap = new LinkedHashMap<String, Map<String, Object>>();
            this.processDataSpecReferences(tenant, baseSpecKey, dataSpec, tenantDataSpecContententMap);
            resultSpec.putAll(tenantDataSpecContententMap);
            String mergedJson = this.jsonMapper.writeValueAsString(resultSpec);
            setter.accept(mergedJson);
        }
        catch (Exception e) {
            log.error("Could not process data spec by tenant {}: ", (Object)tenant, (Object)e);
        }
    }

    public <T> void processDefinition(String tenant, String baseSpecKey, Map<String, Map<String, Object>> tenantDataSpecMap, String dataRef, Map<String, Map<String, Map<String, T>>> originsMap, Function<T, String> specMapper) {
        String keyTemplate = this.getKeyTemplate();
        String key = (String)this.matcher.extractUriTemplateVariables(keyTemplate, dataRef).get("key");
        Map entityDefinitions = tenantDataSpecMap.computeIfAbsent(this.getSectionName(), k -> new LinkedHashMap());
        if (!entityDefinitions.containsKey(key) && StringUtils.isNotBlank((CharSequence)key)) {
            Optional<String> filteredSpec = Optional.ofNullable(originsMap.get(tenant)).map(t -> (Map)t.get(baseSpecKey)).map(x -> x.get(key)).map(specMapper).filter(StringUtils::isNotBlank);
            if (filteredSpec.isEmpty()) {
                log.warn("The specification for key:{} and tenant:{} was not found.", (Object)key, (Object)tenant);
                return;
            }
            this.addSpecificationToDefinitionMap(filteredSpec.get(), key, entityDefinitions);
            this.processDataSpecReferences(tenant, baseSpecKey, filteredSpec.get(), tenantDataSpecMap);
        }
    }

    private void addSpecificationToDefinitionMap(String specification, String definitionKey, Map<String, Object> definitions) {
        try {
            definitions.put(definitionKey, this.jsonMapper.readValue(specification, Map.class));
        }
        catch (JsonProcessingException exception) {
            log.warn("Definition specification by key: {} couldn't be parsed: {}", (Object)definitionKey, (Object)exception.getMessage());
        }
    }
}

