/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.icthh.xm.commons.ObjectMapperUtils;
import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.domain.BaseSpecification;
import com.icthh.xm.commons.enums.SpecPathPatternEnum;
import com.icthh.xm.commons.listener.JsonListenerService;
import com.icthh.xm.commons.logging.aop.IgnoreLogginAspect;
import com.icthh.xm.commons.service.SpecificationProcessingService;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IgnoreLogginAspect
public abstract class DataSpecificationService<S extends BaseSpecification>
implements RefreshableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DataSpecificationService.class);
    private final Class<S> specType;
    private final ObjectMapper objectMapper;
    private final JsonListenerService jsonListenerService;
    private final SpecificationProcessingService<S> specProcessingService;
    private final Map<String, Map<String, S>> specsByTenant;
    private final Map<String, Map<String, String>> specFilesByTenant;

    public DataSpecificationService(Class<S> specType, JsonListenerService jsonListenerService, SpecificationProcessingService<S> specProcessingService) {
        this.specType = specType;
        this.jsonListenerService = jsonListenerService;
        this.specProcessingService = specProcessingService;
        this.objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.specsByTenant = new ConcurrentHashMap<String, Map<String, S>>();
        this.specFilesByTenant = new ConcurrentHashMap<String, Map<String, String>>();
    }

    public void onRefresh(String updatedKey, String config) {
        try {
            String tenant = SpecPathPatternEnum.findTenantName(updatedKey, this.folder());
            switch (SpecPathPatternEnum.getByPath(updatedKey, this.folder()).get()) {
                case SPEC_PATH_PATTERN: 
                case SPEC_FOLDER_PATH_PATTERN: {
                    this.processYmlSpec(tenant, updatedKey, config);
                    break;
                }
                case JSON_CONFIG_PATH_PATTERN: {
                    this.processJsonSpec(tenant, updatedKey, config);
                }
            }
            log.info("Updated spec by tenant {} and file {}", (Object)tenant, (Object)updatedKey);
        }
        catch (Exception e) {
            log.error("Error when update spec by path {} ", (Object)updatedKey, (Object)e);
        }
    }

    private void processYmlSpec(String tenant, String updatedKey, String config) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)config)) {
            this.specFilesByTenant.get(tenant).remove(updatedKey);
            this.specsByTenant.get(tenant).remove(updatedKey);
            log.info("Spec for tenant {} was removed due to empty", (Object)tenant);
        } else {
            this.specFilesByTenant.computeIfAbsent(tenant, key -> new LinkedHashMap()).put(updatedKey, config);
            BaseSpecification specification = (BaseSpecification)this.objectMapper.readValue(config, this.specType);
            this.updateByTenantState(tenant, Map.of(updatedKey, specification));
        }
    }

    private void processJsonSpec(String tenant, String updatedKey, String config) {
        String relativePath = updatedKey.substring(updatedKey.indexOf(this.specKey()));
        this.jsonListenerService.processTenantSpecification(tenant, relativePath, config);
        this.updateByTenantState(tenant, Map.of());
    }

    private void updateByTenantState(String tenant, Map<String, S> newSpecifications) {
        Map<String, S> specificationsMap = this.getSpecificationsMapFromFiles(tenant);
        specificationsMap.putAll(newSpecifications);
        this.specProcessingService.updateByTenantState(tenant, this.specKey(), specificationsMap.values());
        this.specsByTenant.put(tenant, specificationsMap);
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return SpecPathPatternEnum.getByPath(updatedKey, this.folder()).isPresent();
    }

    public Map<String, S> getTenantSpecifications(String tenant) {
        return this.specsByTenant.getOrDefault(tenant, Map.of());
    }

    private Set<S> getSpecificationsFromFiles(String tenantKey) {
        return this.specFilesByTenant.getOrDefault(tenantKey, Map.of()).values().stream().map(config -> ObjectMapperUtils.readSpecYml(tenantKey, config, this.specType)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private Map<String, S> getSpecificationsMapFromFiles(String tenantKey) {
        return this.specFilesByTenant.getOrDefault(tenantKey, Map.of()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ObjectMapperUtils.readSpecYml(tenantKey, (String)e.getValue(), this.specType))).entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, e -> (BaseSpecification)((Optional)e.getValue()).get()));
    }

    public abstract String specKey();

    public abstract String folder();
}

