/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.service;

import com.icthh.xm.commons.domain.BaseSpecification;
import com.icthh.xm.commons.domain.SpecificationItem;
import com.icthh.xm.commons.processor.impl.DefinitionSpecProcessor;
import com.icthh.xm.commons.service.SpecificationProcessingService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractSpecProcessingService<S extends BaseSpecification>
implements SpecificationProcessingService<S> {
    private final DefinitionSpecProcessor definitionSpecProcessor;

    @Override
    public <I extends SpecificationItem> Collection<I> processDataSpecifications(String tenant, String baseSpecKey, Collection<I> specifications) {
        Optional.ofNullable(specifications).orElseGet(List::of).stream().filter(Objects::nonNull).forEach(f -> this.processDataSpecification(tenant, baseSpecKey, f));
        this.definitionSpecProcessor.processDefinitionsItSelf(tenant, baseSpecKey);
        return specifications;
    }

    @Override
    public void updateByTenantState(String tenant, String baseSpecKey, Collection<S> specifications) {
        List<BaseSpecification> filtered = Optional.ofNullable(specifications).orElseGet(List::of).stream().filter(Objects::nonNull).toList();
        filtered.forEach(spec -> this.updateByTenantState(tenant, baseSpecKey, spec));
        filtered.forEach(spec -> this.processSpecification(tenant, baseSpecKey, spec));
    }

    public abstract <I extends SpecificationItem> void processDataSpecification(String var1, String var2, I var3);

    public abstract void updateByTenantState(String var1, String var2, S var3);

    public AbstractSpecProcessingService(DefinitionSpecProcessor definitionSpecProcessor) {
        this.definitionSpecProcessor = definitionSpecProcessor;
    }
}

