/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.enums;

import java.util.Arrays;
import java.util.Optional;
import org.springframework.util.AntPathMatcher;

public enum SpecPathPatternEnum {
    SPEC_PATH_PATTERN("/config/tenants/{tenantName}/{folder}.yml"),
    SPEC_FOLDER_PATH_PATTERN("/config/tenants/{tenantName}/{folder}/*.yml"),
    JSON_CONFIG_PATH_PATTERN("/config/tenants/{tenantName}/{folder}/**/*.json");

    private final String pathPattern;
    private static final String FOLDER_REPLACE_KEY = "{folder}";
    private static final AntPathMatcher matcher;

    public static String findTenantName(String path, String folder) {
        return SpecPathPatternEnum.getByPath(path, folder).map(SpecPathPatternEnum::getPathPattern).map(pattern -> SpecPathPatternEnum.getTenantName(pattern, path, folder)).orElseThrow(() -> new IllegalArgumentException("Could not execute tenantName from path: " + path));
    }

    public static Optional<SpecPathPatternEnum> getByPath(String path, String folder) {
        return Arrays.stream(SpecPathPatternEnum.values()).filter(pattern -> pattern.match(path, folder)).findFirst();
    }

    public String getTenantName(String path, String folder) {
        return SpecPathPatternEnum.getTenantName(this.pathPattern, path, folder);
    }

    public boolean match(String path, String folder) {
        return matcher.match(SpecPathPatternEnum.prepare(this.pathPattern, folder), path);
    }

    private static String prepare(String pathPattern, String folder) {
        return pathPattern.replace(FOLDER_REPLACE_KEY, folder);
    }

    private static String getTenantName(String pattern, String path, String folder) {
        return (String)matcher.extractUriTemplateVariables(SpecPathPatternEnum.prepare(pattern, folder), path).get("tenantName");
    }

    public String getPathPattern() {
        return this.pathPattern;
    }

    private SpecPathPatternEnum(String pathPattern) {
        this.pathPattern = pathPattern;
    }

    static {
        matcher = new AntPathMatcher();
    }
}

