/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.listener;

import com.icthh.xm.commons.config.client.api.RefreshableConfiguration;
import com.icthh.xm.commons.listener.JsonListenerService;
import java.util.Collection;
import org.springframework.util.AntPathMatcher;

public abstract class AbstractJsonConfigurationListener
implements RefreshableConfiguration {
    private final String mappingPath;
    private final AntPathMatcher matcher;
    private final JsonListenerService jsonListenerService;

    public AbstractJsonConfigurationListener(String mappingPath, JsonListenerService jsonListenerService) {
        this.jsonListenerService = jsonListenerService;
        this.mappingPath = mappingPath;
        this.matcher = new AntPathMatcher();
    }

    public void onRefresh(String updatedKey, String config) {
        String tenantName = this.extractTenantName(updatedKey);
        String relativePath = updatedKey.substring(updatedKey.indexOf(this.getSpecificationKey()));
        this.jsonListenerService.processTenantSpecification(tenantName, relativePath, config);
    }

    public boolean isListeningConfiguration(String updatedKey) {
        return this.matcher.match(this.mappingPath, updatedKey);
    }

    public void refreshFinished(Collection<String> paths) {
        paths.stream().map(this::extractTenantName).forEach(this::updateByTenantState);
    }

    private String extractTenantName(String updatedKey) {
        return (String)this.matcher.extractUriTemplateVariables(this.mappingPath, updatedKey).get("tenantName");
    }

    public abstract String getSpecificationKey();

    public abstract void updateByTenantState(String var1);
}

