/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.utils;

import com.icthh.xm.commons.config.client.utils.TokenUtils;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

public final class RequestUtils {
    public static HttpHeaders createAuthHeaders() {
        return RequestUtils.createAuthHeaders(new MediaType(MediaType.TEXT_PLAIN, StandardCharsets.UTF_8));
    }

    public static HttpHeaders createMultipartAuthHeaders() {
        return RequestUtils.createAuthHeaders(MediaType.MULTIPART_FORM_DATA);
    }

    public static HttpHeaders createJsonAuthHeaders() {
        return RequestUtils.createAuthHeaders(new MediaType(MediaType.APPLICATION_JSON, StandardCharsets.UTF_8));
    }

    public static HttpHeaders createSimpleHeaders() {
        return RequestUtils.createHeaders(new MediaType(MediaType.TEXT_PLAIN, StandardCharsets.UTF_8));
    }

    public static HttpHeaders createApplicationJsonHeaders() {
        return RequestUtils.createHeaders(new MediaType(MediaType.APPLICATION_JSON, StandardCharsets.UTF_8));
    }

    public static HttpHeaders createAuthHeaders(MediaType mediaType) {
        HttpHeaders headers = RequestUtils.createHeaders(mediaType);
        headers.set("Authorization", "Bearer " + TokenUtils.extractCurrentToken());
        return headers;
    }

    public static HttpHeaders createHeaders(MediaType mediaType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(mediaType);
        return headers;
    }

    private RequestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

