/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.listener;

import com.icthh.xm.commons.config.client.config.XmConfigProperties;
import com.icthh.xm.commons.config.client.repository.kafka.ConfigTopicConsumer;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.MessageListener;

public class ApplicationReadyEventListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationReadyEventListener.class);
    private final ConsumerFactory<String, String> consumerFactory;
    private final ConfigTopicConsumer configTopicConsumer;
    private final KafkaProperties kafkaProperties;
    private final XmConfigProperties xmConfigProperties;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.createSystemConsumer(this.xmConfigProperties.getKafkaConfigTopic(), (MessageListener<String, String>)((MessageListener)this.configTopicConsumer::consumeEvent));
    }

    private void createSystemConsumer(String name, MessageListener<String, String> consumeEvent) {
        log.info("Creating kafka consumer for topic {}", (Object)name);
        ContainerProperties containerProps = new ContainerProperties(new String[]{name});
        Map props = this.kafkaProperties.buildConsumerProperties();
        props.put("group.id", UUID.randomUUID().toString());
        DefaultKafkaConsumerFactory factory = new DefaultKafkaConsumerFactory(props);
        ConcurrentMessageListenerContainer container = new ConcurrentMessageListenerContainer((ConsumerFactory)factory, containerProps);
        container.setupMessageListener(consumeEvent);
        container.start();
        log.info("Successfully created kafka consumer for topic {}", (Object)name);
    }

    public ApplicationReadyEventListener(ConsumerFactory<String, String> consumerFactory, ConfigTopicConsumer configTopicConsumer, KafkaProperties kafkaProperties, XmConfigProperties xmConfigProperties) {
        this.consumerFactory = consumerFactory;
        this.configTopicConsumer = configTopicConsumer;
        this.kafkaProperties = kafkaProperties;
        this.xmConfigProperties = xmConfigProperties;
    }
}

