/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config.client.config;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"xm-config.enabled"})
@ConfigurationProperties(prefix="xm-config", ignoreUnknownFields=false)
public class XmConfigProperties {
    private Boolean enabled;
    private String xmConfigUrl;
    private String tenantConfigPattern;
    private String kafkaConfigTopic;
    private Set<String> includeTenants;

    public Set<String> getIncludeTenantLowercase() {
        return ((Set)Optional.ofNullable(this.getIncludeTenants()).orElse(new HashSet())).stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getXmConfigUrl() {
        return this.xmConfigUrl;
    }

    public String getTenantConfigPattern() {
        return this.tenantConfigPattern;
    }

    public String getKafkaConfigTopic() {
        return this.kafkaConfigTopic;
    }

    public Set<String> getIncludeTenants() {
        return this.includeTenants;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setXmConfigUrl(String xmConfigUrl) {
        this.xmConfigUrl = xmConfigUrl;
    }

    public void setTenantConfigPattern(String tenantConfigPattern) {
        this.tenantConfigPattern = tenantConfigPattern;
    }

    public void setKafkaConfigTopic(String kafkaConfigTopic) {
        this.kafkaConfigTopic = kafkaConfigTopic;
    }

    public void setIncludeTenants(Set<String> includeTenants) {
        this.includeTenants = includeTenants;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XmConfigProperties)) {
            return false;
        }
        XmConfigProperties other = (XmConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$xmConfigUrl = this.getXmConfigUrl();
        String other$xmConfigUrl = other.getXmConfigUrl();
        if (this$xmConfigUrl == null ? other$xmConfigUrl != null : !this$xmConfigUrl.equals(other$xmConfigUrl)) {
            return false;
        }
        String this$tenantConfigPattern = this.getTenantConfigPattern();
        String other$tenantConfigPattern = other.getTenantConfigPattern();
        if (this$tenantConfigPattern == null ? other$tenantConfigPattern != null : !this$tenantConfigPattern.equals(other$tenantConfigPattern)) {
            return false;
        }
        String this$kafkaConfigTopic = this.getKafkaConfigTopic();
        String other$kafkaConfigTopic = other.getKafkaConfigTopic();
        if (this$kafkaConfigTopic == null ? other$kafkaConfigTopic != null : !this$kafkaConfigTopic.equals(other$kafkaConfigTopic)) {
            return false;
        }
        Set<String> this$includeTenants = this.getIncludeTenants();
        Set<String> other$includeTenants = other.getIncludeTenants();
        return !(this$includeTenants == null ? other$includeTenants != null : !((Object)this$includeTenants).equals(other$includeTenants));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XmConfigProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $xmConfigUrl = this.getXmConfigUrl();
        result = result * 59 + ($xmConfigUrl == null ? 43 : $xmConfigUrl.hashCode());
        String $tenantConfigPattern = this.getTenantConfigPattern();
        result = result * 59 + ($tenantConfigPattern == null ? 43 : $tenantConfigPattern.hashCode());
        String $kafkaConfigTopic = this.getKafkaConfigTopic();
        result = result * 59 + ($kafkaConfigTopic == null ? 43 : $kafkaConfigTopic.hashCode());
        Set<String> $includeTenants = this.getIncludeTenants();
        result = result * 59 + ($includeTenants == null ? 43 : ((Object)$includeTenants).hashCode());
        return result;
    }

    public String toString() {
        return "XmConfigProperties(enabled=" + this.getEnabled() + ", xmConfigUrl=" + this.getXmConfigUrl() + ", tenantConfigPattern=" + this.getTenantConfigPattern() + ", kafkaConfigTopic=" + this.getKafkaConfigTopic() + ", includeTenants=" + this.getIncludeTenants() + ")";
    }
}

